"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemRuleMigrationsTranslationStatsRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _rule_migration = require("../../../../../common/siem_migrations/model/api/rules/rule_migration.gen");
var _constants = require("../../../../../common/siem_migrations/constants");
var _authz = require("../../common/api/util/authz");
var _with_license = require("../../common/api/util/with_license");
var _with_existing_migration_id = require("../../common/api/util/with_existing_migration_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemRuleMigrationsTranslationStatsRoute = (router, logger) => {
  router.versioned.get({
    path: _constants.SIEM_RULE_MIGRATION_TRANSLATION_STATS_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        params: (0, _zodHelpers.buildRouteValidationWithZod)(_rule_migration.GetRuleMigrationTranslationStatsRequestParams)
      }
    }
  }, (0, _with_license.withLicense)((0, _with_existing_migration_id.withExistingMigration)(async (context, req, res) => {
    const migrationId = req.params.migration_id;
    try {
      const ctx = await context.resolve(['securitySolution']);
      const ruleMigrationsClient = ctx.securitySolution.siemMigrations.getRulesClient();
      const stats = await ruleMigrationsClient.data.items.getTranslationStats(migrationId);
      if (stats.rules.total === 0) {
        return res.noContent();
      }
      return res.ok({
        body: stats
      });
    } catch (err) {
      logger.error(err);
      return res.badRequest({
        body: err.message
      });
    }
  })));
};
exports.registerSiemRuleMigrationsTranslationStatsRoute = registerSiemRuleMigrationsTranslationStatsRoute;