"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemRuleMigrationsPrebuiltRulesRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _rule_migration = require("../../../../../common/siem_migrations/model/api/rules/rule_migration.gen");
var _constants = require("../../../../../common/siem_migrations/constants");
var _authz = require("../../common/api/util/authz");
var _with_license = require("../../common/api/util/with_license");
var _prebuilt_rules = require("./util/prebuilt_rules");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemRuleMigrationsPrebuiltRulesRoute = (router, logger) => {
  router.versioned.get({
    path: _constants.SIEM_RULE_MIGRATIONS_PREBUILT_RULES_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        params: (0, _zodHelpers.buildRouteValidationWithZod)(_rule_migration.GetRuleMigrationPrebuiltRulesRequestParams)
      }
    }
  }, (0, _with_license.withLicense)(async (context, req, res) => {
    const {
      migration_id: migrationId
    } = req.params;
    try {
      const ctx = await context.resolve(['core', 'alerting', 'securitySolution']);
      const ruleMigrationsClient = ctx.securitySolution.siemMigrations.getRulesClient();
      const savedObjectsClient = ctx.core.savedObjects.client;
      const rulesClient = await ctx.alerting.getRulesClient();
      const prebuiltRules = await (0, _prebuilt_rules.getPrebuiltRulesForMigration)(migrationId, ruleMigrationsClient, rulesClient, savedObjectsClient);
      return res.ok({
        body: prebuiltRules
      });
    } catch (err) {
      logger.error(err);
      return res.badRequest({
        body: err.message
      });
    }
  }));
};
exports.registerSiemRuleMigrationsPrebuiltRulesRoute = registerSiemRuleMigrationsPrebuiltRulesRoute;