"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemRuleMigrationsGetRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _constants = require("../../../../../common/siem_migrations/constants");
var _rule_migration = require("../../../../../common/siem_migrations/model/api/rules/rule_migration.gen");
var _audit = require("../../common/api/util/audit");
var _authz = require("../../common/api/util/authz");
var _with_license = require("../../common/api/util/with_license");
var _translations = require("../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemRuleMigrationsGetRoute = (router, logger) => {
  router.versioned.get({
    path: _constants.SIEM_RULE_MIGRATION_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        params: (0, _zodHelpers.buildRouteValidationWithZod)(_rule_migration.GetRuleMigrationRequestParams)
      }
    }
  }, (0, _with_license.withLicense)(async (context, req, res) => {
    const siemMigrationAuditLogger = new _audit.SiemMigrationAuditLogger(context.securitySolution, 'rules');
    const {
      migration_id: migrationId
    } = req.params;
    try {
      const ctx = await context.resolve(['securitySolution']);
      const ruleMigrationsClient = ctx.securitySolution.siemMigrations.getRulesClient();
      await siemMigrationAuditLogger.logGetMigration({
        migrationId
      });
      const storedMigration = await ruleMigrationsClient.data.migrations.get(migrationId);
      if (!storedMigration) {
        return res.notFound({
          body: (0, _translations.MIGRATION_ID_NOT_FOUND)(migrationId)
        });
      }
      return res.ok({
        body: storedMigration
      });
    } catch (error) {
      logger.error(error);
      await siemMigrationAuditLogger.logGetMigration({
        migrationId,
        error
      });
      return res.badRequest({
        body: error.message
      });
    }
  }));
};
exports.registerSiemRuleMigrationsGetRoute = registerSiemRuleMigrationsGetRoute;