"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.translateDashboardPanelState = void 0;
var _langgraph = require("@langchain/langgraph");
var _constants = require("../../../../../../../../common/siem_migrations/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const translateDashboardPanelState = exports.translateDashboardPanelState = _langgraph.Annotation.Root({
  parsed_panel: (0, _langgraph.Annotation)(),
  description: (0, _langgraph.Annotation)(),
  dashboard_description: (0, _langgraph.Annotation)(),
  resources: (0, _langgraph.Annotation)(),
  elastic_panel: (0, _langgraph.Annotation)(),
  // The visualization panel object
  index_pattern: (0, _langgraph.Annotation)(),
  index_mapping: (0, _langgraph.Annotation)(),
  includes_ecs_mapping: (0, _langgraph.Annotation)({
    reducer: (current, value) => value !== null && value !== void 0 ? value : current,
    default: () => false
  }),
  inline_query: (0, _langgraph.Annotation)(),
  esql_query: (0, _langgraph.Annotation)(),
  esql_query_columns: (0, _langgraph.Annotation)(),
  validation_errors: (0, _langgraph.Annotation)({
    reducer: (current, value) => value !== null && value !== void 0 ? value : current,
    default: () => ({
      retries_left: 3
    }) // Max self-healing ES|QL validation retries
  }),
  translation_result: (0, _langgraph.Annotation)({
    reducer: (current, value) => value !== null && value !== void 0 ? value : current,
    default: () => _constants.MigrationTranslationResult.UNTRANSLATABLE
  }),
  comments: (0, _langgraph.Annotation)({
    reducer: (current, value) => value ? (current !== null && current !== void 0 ? current : []).concat(value) : current,
    default: () => []
  })
});