"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processPanel = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Process the panel and return the modified panelJSON
const processPanel = (panel, query, esqlColumns, parsedPanel) => {
  const panelJSON = structuredClone(panel);
  const {
    columnList,
    columns
  } = parseColumns(esqlColumns);
  const vizType = parsedPanel.viz_type;

  // Set panel basic properties
  panelJSON.title = parsedPanel.title;

  // Set position from parsed_panel.position
  if (parsedPanel.position) {
    panelJSON.gridData = {
      x: parsedPanel.position.x,
      y: parsedPanel.position.y,
      w: parsedPanel.position.w,
      h: parsedPanel.position.h,
      i: parsedPanel.id
    };
    panelJSON.panelIndex = parsedPanel.id;
  }

  // Configure visualization-specific properties
  configureVixTypeProperties(panelJSON, vizType, query, columns);
  configureStackedProperties(panelJSON, vizType, columns);
  configureDatasourceProperties(panelJSON, query, columnList);
  return panelJSON;
};

// Parse columns from ESQL query and build column array for panel JSON
exports.processPanel = processPanel;
function parseColumns(extractedColumns) {
  const columnList = [];
  const columnNames = [];
  extractedColumns.forEach(({
    name: columnName,
    type
  }, index) => {
    if (index === 0) {
      columnList.push({
        columnId: columnName,
        fieldName: columnName,
        meta: {
          type
        },
        /* The first column is mostly a metric so here we are making that assumption
         * unless we have better way to do this. */
        inMetricDimension: true
      });
    } else {
      columnList.push({
        columnId: columnName,
        fieldName: columnName,
        meta: {
          type: 'string'
        }
      });
    }
    columnNames.push(columnName);
  });
  return {
    columnList,
    columns: columnNames
  };
}

// Configure chart-specific properties
function configureVixTypeProperties(panelJSON, vizType, query, columns) {
  const chartTypes = ['bar', 'bar_vertical', 'bar_horizontal', 'bar_vertical_stacked', 'bar_horizontal_stacked', 'area', 'area_stacked', 'line', 'heatmap'];
  if (chartTypes.includes(vizType)) {
    var _panelJSON$embeddable, _panelJSON$embeddable2, _panelJSON$embeddable3, _panelJSON$embeddable4, _panelJSON$embeddable5;
    if ((_panelJSON$embeddable = panelJSON.embeddableConfig) !== null && _panelJSON$embeddable !== void 0 && (_panelJSON$embeddable2 = _panelJSON$embeddable.attributes) !== null && _panelJSON$embeddable2 !== void 0 && (_panelJSON$embeddable3 = _panelJSON$embeddable2.state) !== null && _panelJSON$embeddable3 !== void 0 && (_panelJSON$embeddable4 = _panelJSON$embeddable3.visualization) !== null && _panelJSON$embeddable4 !== void 0 && (_panelJSON$embeddable5 = _panelJSON$embeddable4.layers) !== null && _panelJSON$embeddable5 !== void 0 && _panelJSON$embeddable5[0]) {
      panelJSON.embeddableConfig.attributes.state.visualization.layers[0].xAccessor = columns[columns.length - 1];
      panelJSON.embeddableConfig.attributes.state.visualization.layers[0].accessors = [columns[0]];
    }
  }
  if (vizType === 'pie') {
    var _panelJSON$embeddable6, _panelJSON$embeddable7, _panelJSON$embeddable8, _panelJSON$embeddable9, _panelJSON$embeddable10;
    if ((_panelJSON$embeddable6 = panelJSON.embeddableConfig) !== null && _panelJSON$embeddable6 !== void 0 && (_panelJSON$embeddable7 = _panelJSON$embeddable6.attributes) !== null && _panelJSON$embeddable7 !== void 0 && (_panelJSON$embeddable8 = _panelJSON$embeddable7.state) !== null && _panelJSON$embeddable8 !== void 0 && (_panelJSON$embeddable9 = _panelJSON$embeddable8.visualization) !== null && _panelJSON$embeddable9 !== void 0 && (_panelJSON$embeddable10 = _panelJSON$embeddable9.layers) !== null && _panelJSON$embeddable10 !== void 0 && _panelJSON$embeddable10[0]) {
      panelJSON.embeddableConfig.attributes.state.visualization.layers[0].primaryGroups = [columns[columns.length - 1]];
      panelJSON.embeddableConfig.attributes.state.visualization.layers[0].metrics = [[columns[0]]];
    }
  }
  if (vizType === 'table') {
    var _panelJSON$embeddable11, _panelJSON$embeddable12, _panelJSON$embeddable13;
    if ((_panelJSON$embeddable11 = panelJSON.embeddableConfig) !== null && _panelJSON$embeddable11 !== void 0 && (_panelJSON$embeddable12 = _panelJSON$embeddable11.attributes) !== null && _panelJSON$embeddable12 !== void 0 && (_panelJSON$embeddable13 = _panelJSON$embeddable12.state) !== null && _panelJSON$embeddable13 !== void 0 && _panelJSON$embeddable13.visualization) {
      panelJSON.embeddableConfig.attributes.state.visualization.columns = columns.map(column => ({
        columnId: column
      }));
    }
  }
  if (vizType === 'heatmap') {
    configureHeatmapProperties(panelJSON, columns);
  }
  if (vizType === 'treemap') {
    configureTreemapProperties(panelJSON, columns);
  }

  // Handle metric visualization
  if (vizType === 'metric') {
    var _panelJSON$embeddable14, _panelJSON$embeddable15, _panelJSON$embeddable16;
    if ((_panelJSON$embeddable14 = panelJSON.embeddableConfig) !== null && _panelJSON$embeddable14 !== void 0 && (_panelJSON$embeddable15 = _panelJSON$embeddable14.attributes) !== null && _panelJSON$embeddable15 !== void 0 && (_panelJSON$embeddable16 = _panelJSON$embeddable15.state) !== null && _panelJSON$embeddable16 !== void 0 && _panelJSON$embeddable16.visualization) {
      panelJSON.embeddableConfig.attributes.state.visualization.metricAccessor = columns[0];
    }
  }

  // Handle gauge visualization
  if (vizType === 'gauge') {
    configureGaugeProperties(panelJSON, query, columns);
  }
}

// Configure heatmap specific properties
function configureHeatmapProperties(panelJSON, columns) {
  var _panelJSON$embeddable17, _panelJSON$embeddable18, _panelJSON$embeddable19;
  if ((_panelJSON$embeddable17 = panelJSON.embeddableConfig) !== null && _panelJSON$embeddable17 !== void 0 && (_panelJSON$embeddable18 = _panelJSON$embeddable17.attributes) !== null && _panelJSON$embeddable18 !== void 0 && (_panelJSON$embeddable19 = _panelJSON$embeddable18.state) !== null && _panelJSON$embeddable19 !== void 0 && _panelJSON$embeddable19.visualization) {
    panelJSON.embeddableConfig.attributes.state.visualization.valueAccessor = columns[0];
    panelJSON.embeddableConfig.attributes.state.visualization.xAccessor = columns[columns.length - 1];
    if (columns.length > 1) {
      panelJSON.embeddableConfig.attributes.state.visualization.yAccessor = columns[columns.length - 2];
    }
  }
}

// Configure treemap specific properties
function configureTreemapProperties(panelJSON, columns) {
  var _panelJSON$embeddable20, _panelJSON$embeddable21, _panelJSON$embeddable22, _panelJSON$embeddable23, _panelJSON$embeddable24;
  if ((_panelJSON$embeddable20 = panelJSON.embeddableConfig) !== null && _panelJSON$embeddable20 !== void 0 && (_panelJSON$embeddable21 = _panelJSON$embeddable20.attributes) !== null && _panelJSON$embeddable21 !== void 0 && (_panelJSON$embeddable22 = _panelJSON$embeddable21.state) !== null && _panelJSON$embeddable22 !== void 0 && (_panelJSON$embeddable23 = _panelJSON$embeddable22.visualization) !== null && _panelJSON$embeddable23 !== void 0 && (_panelJSON$embeddable24 = _panelJSON$embeddable23.layers) !== null && _panelJSON$embeddable24 !== void 0 && _panelJSON$embeddable24[0]) {
    if (panelJSON.embeddableConfig.attributes.state.visualization.layers[0].metrics) {
      panelJSON.embeddableConfig.attributes.state.visualization.layers[0].metrics.push(columns[0]);
    }
    if (panelJSON.embeddableConfig.attributes.state.visualization.layers[0].primaryGroups) {
      for (let i = 1; i < columns.length - 1; i++) {
        panelJSON.embeddableConfig.attributes.state.visualization.layers[0].primaryGroups.push(columns[i]);
      }
    }
  }
}

// Configure gauge visualization
function configureGaugeProperties(panelJSON, query, columns) {
  var _panelJSON$embeddable25, _panelJSON$embeddable26, _panelJSON$embeddable27, _panelJSON$embeddable28, _panelJSON$embeddable29, _panelJSON$embeddable30, _panelJSON$embeddable31, _panelJSON$embeddable32, _panelJSON$embeddable33;
  const gaugeLayerId = '3b1b0102-bb45-40f5-9ef2-419d2eaaa56c';
  if ((_panelJSON$embeddable25 = panelJSON.embeddableConfig) !== null && _panelJSON$embeddable25 !== void 0 && (_panelJSON$embeddable26 = _panelJSON$embeddable25.attributes) !== null && _panelJSON$embeddable26 !== void 0 && (_panelJSON$embeddable27 = _panelJSON$embeddable26.state) !== null && _panelJSON$embeddable27 !== void 0 && (_panelJSON$embeddable28 = _panelJSON$embeddable27.datasourceStates) !== null && _panelJSON$embeddable28 !== void 0 && (_panelJSON$embeddable29 = _panelJSON$embeddable28.textBased) !== null && _panelJSON$embeddable29 !== void 0 && (_panelJSON$embeddable30 = _panelJSON$embeddable29.layers) !== null && _panelJSON$embeddable30 !== void 0 && _panelJSON$embeddable30[gaugeLayerId]) {
    var _gaugeLayer$columns;
    const gaugeLayer = panelJSON.embeddableConfig.attributes.state.datasourceStates.textBased.layers[gaugeLayerId];
    if ((_gaugeLayer$columns = gaugeLayer.columns) !== null && _gaugeLayer$columns !== void 0 && _gaugeLayer$columns[0]) {
      gaugeLayer.columns[0].fieldName = columns[0];
      gaugeLayer.columns[0].columnId = columns[0];
    }
    gaugeLayer.query = {
      esql: query
    };
  }
  if ((_panelJSON$embeddable31 = panelJSON.embeddableConfig) !== null && _panelJSON$embeddable31 !== void 0 && (_panelJSON$embeddable32 = _panelJSON$embeddable31.attributes) !== null && _panelJSON$embeddable32 !== void 0 && (_panelJSON$embeddable33 = _panelJSON$embeddable32.state) !== null && _panelJSON$embeddable33 !== void 0 && _panelJSON$embeddable33.visualization) {
    panelJSON.embeddableConfig.attributes.state.visualization.metricAccessor = columns[0];
  }
}

// Configure stacked chart properties
function configureStackedProperties(panelJSON, vizType, columns) {
  if ((vizType.includes('stacked') || vizType.includes('line')) && columns.length > 2) {
    var _panelJSON$embeddable34, _panelJSON$embeddable35, _panelJSON$embeddable36, _panelJSON$embeddable37, _panelJSON$embeddable38;
    if ((_panelJSON$embeddable34 = panelJSON.embeddableConfig) !== null && _panelJSON$embeddable34 !== void 0 && (_panelJSON$embeddable35 = _panelJSON$embeddable34.attributes) !== null && _panelJSON$embeddable35 !== void 0 && (_panelJSON$embeddable36 = _panelJSON$embeddable35.state) !== null && _panelJSON$embeddable36 !== void 0 && (_panelJSON$embeddable37 = _panelJSON$embeddable36.visualization) !== null && _panelJSON$embeddable37 !== void 0 && (_panelJSON$embeddable38 = _panelJSON$embeddable37.layers) !== null && _panelJSON$embeddable38 !== void 0 && _panelJSON$embeddable38[0]) {
      panelJSON.embeddableConfig.attributes.state.visualization.layers[0].splitAccessor = columns[columns.length - 2];
    }
  }
  if (vizType.includes('stacked') && columns.length === 2) {
    var _panelJSON$embeddable39, _panelJSON$embeddable40, _panelJSON$embeddable41, _panelJSON$embeddable42, _panelJSON$embeddable43;
    if ((_panelJSON$embeddable39 = panelJSON.embeddableConfig) !== null && _panelJSON$embeddable39 !== void 0 && (_panelJSON$embeddable40 = _panelJSON$embeddable39.attributes) !== null && _panelJSON$embeddable40 !== void 0 && (_panelJSON$embeddable41 = _panelJSON$embeddable40.state) !== null && _panelJSON$embeddable41 !== void 0 && (_panelJSON$embeddable42 = _panelJSON$embeddable41.visualization) !== null && _panelJSON$embeddable42 !== void 0 && (_panelJSON$embeddable43 = _panelJSON$embeddable42.layers) !== null && _panelJSON$embeddable43 !== void 0 && _panelJSON$embeddable43[0]) {
      panelJSON.embeddableConfig.attributes.state.visualization.layers[0].splitAccessor = columns[columns.length - 1];
    }
  }
}

// Configure datasource properties
function configureDatasourceProperties(panelJSON, query, columnList) {
  var _panelJSON$embeddable44, _panelJSON$embeddable45, _panelJSON$embeddable46, _panelJSON$embeddable47, _panelJSON$embeddable48, _panelJSON$embeddable49, _panelJSON$embeddable50, _panelJSON$embeddable51;
  if ((_panelJSON$embeddable44 = panelJSON.embeddableConfig) !== null && _panelJSON$embeddable44 !== void 0 && (_panelJSON$embeddable45 = _panelJSON$embeddable44.attributes) !== null && _panelJSON$embeddable45 !== void 0 && (_panelJSON$embeddable46 = _panelJSON$embeddable45.state) !== null && _panelJSON$embeddable46 !== void 0 && (_panelJSON$embeddable47 = _panelJSON$embeddable46.datasourceStates) !== null && _panelJSON$embeddable47 !== void 0 && (_panelJSON$embeddable48 = _panelJSON$embeddable47.textBased) !== null && _panelJSON$embeddable48 !== void 0 && _panelJSON$embeddable48.layers) {
    const layerId = '3a5310ab-2832-41db-bdbe-1b6939dd5651';
    if (panelJSON.embeddableConfig.attributes.state.datasourceStates.textBased.layers[layerId]) {
      panelJSON.embeddableConfig.attributes.state.datasourceStates.textBased.layers[layerId].query = {
        esql: query
      };
      panelJSON.embeddableConfig.attributes.state.datasourceStates.textBased.layers[layerId].columns = columnList;
    }
  }
  if ((_panelJSON$embeddable49 = panelJSON.embeddableConfig) !== null && _panelJSON$embeddable49 !== void 0 && (_panelJSON$embeddable50 = _panelJSON$embeddable49.attributes) !== null && _panelJSON$embeddable50 !== void 0 && (_panelJSON$embeddable51 = _panelJSON$embeddable50.state) !== null && _panelJSON$embeddable51 !== void 0 && _panelJSON$embeddable51.query) {
    panelJSON.embeddableConfig.attributes.state.query.esql = query;
  }
}