"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInlineQueryNode = void 0;
var _inline_spl_query = require("../../../../../../../common/task/agent/helpers/inline_spl_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInlineQueryNode = params => {
  const inlineSplQuery = (0, _inline_spl_query.getInlineSplQuery)(params);
  return async state => {
    // NOTE: "inputlookup" is not currently supported, to make it supported we need to parametrize the unsupported check logic here, and the Splunk lookups identifier.
    const {
      inlineQuery,
      isUnsupported,
      comments
    } = await inlineSplQuery({
      query: state.parsed_panel.query,
      resources: state.resources
    });
    if (isUnsupported) {
      // Graph conditional edge detects undefined inline_query as unsupported query
      return {
        inline_query: undefined,
        comments
      };
    }
    return {
      inline_query: inlineQuery !== null && inlineQuery !== void 0 ? inlineQuery : state.parsed_panel.query,
      comments
    };
  };
};
exports.getInlineQueryNode = getInlineQueryNode;