"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexMappingNode = void 0;
var _onechatGenaiUtils = require("@kbn/onechat-genai-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIndexMappingNode = params => {
  return async state => {
    if (!state.index_pattern) {
      params.logger.warn('No index pattern available for getting mapping');
      return {};
    }
    try {
      const mappings = await (0, _onechatGenaiUtils.getIndexMappings)({
        indices: [state.index_pattern],
        esClient: params.esScopedClient.asInternalUser,
        cleanup: true
      });
      if (!mappings || Object.keys(mappings).length === 0) {
        params.logger.warn(`No mappings found for index: ${state.index_pattern}`);
        return {};
      }
      return {
        index_mapping: mappings
      };
    } catch (error) {
      params.logger.error(`Error getting index mapping: ${error}`);
      return {};
    }
  };
};
exports.getIndexMappingNode = getIndexMappingNode;