"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CORRECT_COLUMNS_FROM_MAPPING_TEMPLATE = void 0;
var _prompts = require("@langchain/core/prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CORRECT_COLUMNS_FROM_MAPPING_TEMPLATE = exports.CORRECT_COLUMNS_FROM_MAPPING_TEMPLATE = _prompts.ChatPromptTemplate.fromTemplate(`You are a helpful ES|QL (Elasticsearch Query Language) expert agent.
Your task is to verify and correct column names, field references and functions in an ES|QL query based on the provided index mapping.

Guidelines:
- You will be provided with an ES|QL query and an index mapping.
- Verify that all column names, field references, and field paths in the query match the actual field names in the mapping, and that all functions are valid.
- Pay special attention to:
  * Index patterns in Source commands (FROM, ROWS, SHOW, TS)
  * Field names in Processing commands (EVAL, ENRICH, STATS, etc.)
  * Field names in functions (COUNT, SUM, AVG, MIN, MAX, etc.)
  * Field types in the mapping match what's allowed by the function, i.e. date for date-time functions, keyword or text for string functions, etc.
  * Nested field paths (e.g., "user.name" should match the mapping structure)
- If a field name doesn't match the mapping exactly, correct it to match the actual field name in the mapping.
- Preserve the query structure, logic, and intent while only correcting field names.
- If the query is already correct, return it unchanged.
- You must respond only with a valid JSON object inside a \`\`\`json code block in the schema: {{"corrected_query": "ES|QL query string", "corrections_made": ["list of corrections made"]}}.
- If no corrections are needed, return an empty array for corrections_made.

<context>

<esql_query>
{esql_query}
</esql_query>

<index_mapping>
{index_mapping}
</index_mapping>

</context>
`);