"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCorrectColumnsFromMappingNode = void 0;
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCorrectColumnsFromMappingNode = ({
  esqlKnowledgeBase,
  logger
}) => {
  return async state => {
    const query = state.esql_query;
    const mapping = state.index_mapping;
    if (!query) {
      logger.warn('No ES|QL query available for column correction');
      return {};
    }
    if (!mapping || Object.keys(mapping).length === 0) {
      logger.warn('No index mapping available for column correction');
      return {};
    }
    const mappingString = JSON.stringify(mapping, null, 2);
    const prompt = await _prompts.CORRECT_COLUMNS_FROM_MAPPING_TEMPLATE.format({
      esql_query: query,
      index_mapping: mappingString
    });
    const response = await esqlKnowledgeBase.translate(prompt);
    try {
      var _response$match;
      const outputJsonStr = (_response$match = response.match(/```json\n([\s\S]*?)\n```/)) === null || _response$match === void 0 ? void 0 : _response$match[1];
      if (!outputJsonStr) {
        throw new Error('No JSON found in the response');
      }
      const outputJson = JSON.parse(outputJsonStr);
      if (!outputJson.corrected_query) {
        logger.warn('No corrected query returned from column correction');
        return {};
      }
      if (outputJson.corrections_made && outputJson.corrections_made.length > 0) {
        logger.debug(`Column corrections made: ${outputJson.corrections_made.join(', ')}`);
      }
      return {
        esql_query: outputJson.corrected_query
      };
    } catch (e) {
      const message = `Failed to parse JSON when correcting columns from mapping. Error: ${e}`;
      logger.error(message);
      return {};
    }
  };
};
exports.getCorrectColumnsFromMappingNode = getCorrectColumnsFromMappingNode;