"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTranslatePanelGraph = getTranslatePanelGraph;
var _langgraph = require("@langchain/langgraph");
var _fp = require("lodash/fp");
var _ecs_mapping = require("./nodes/ecs_mapping");
var _fix_query_errors = require("./nodes/fix_query_errors");
var _inline_query = require("./nodes/inline_query");
var _translate_query = require("./nodes/translate_query");
var _translation_result = require("./nodes/translation_result");
var _validation = require("./nodes/validation");
var _state = require("./state");
var _state2 = require("../../state");
var _select_index_pattern = require("./nodes/select_index_pattern");
var _constants = require("../../constants");
var _extract_columns = require("./nodes/extract_columns");
var _get_index_mapping = require("./nodes/get_index_mapping");
var _correct_columns_from_mapping = require("./nodes/correct_columns_from_mapping");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTranslatePanelGraph(params) {
  const translateQueryNode = (0, _translate_query.getTranslateQueryNode)(params);
  const inlineQueryNode = (0, _inline_query.getInlineQueryNode)(params);
  const validationNode = (0, _validation.getValidationNode)(params);
  const fixQueryErrorsNode = (0, _fix_query_errors.getFixQueryErrorsNode)(params);
  const ecsMappingNode = (0, _ecs_mapping.getEcsMappingNode)(params);
  const extractColumnsFromEsqlNode = (0, _extract_columns.getExtractColumnsFromEsqlQueryNode)(params);
  const selectIndexPatternNode = (0, _select_index_pattern.getSelectIndexPatternNode)(params);
  const translationResultNode = (0, _translation_result.getTranslationResultNode)(params);
  const correctColumnsFromMappingNode = (0, _correct_columns_from_mapping.getCorrectColumnsFromMappingNode)({
    esqlKnowledgeBase: params.esqlKnowledgeBase,
    logger: params.logger
  });
  const getIndexMappingNodeInstance = (0, _get_index_mapping.getIndexMappingNode)(params);
  const translateDashboardPanelGraph = new _langgraph.StateGraph(_state.translateDashboardPanelState, _state2.migrateDashboardConfigSchema)
  // Nodes
  .addNode('inlineQuery', inlineQueryNode, {
    retryPolicy: _constants.RETRY_POLICY
  }).addNode('getIndexMapping', getIndexMappingNodeInstance).addNode('translateQuery', translateQueryNode, {
    retryPolicy: _constants.RETRY_POLICY
  }).addNode('validation', validationNode).addNode('fixQueryErrors', fixQueryErrorsNode, {
    retryPolicy: _constants.RETRY_POLICY
  }).addNode('ecsMapping', ecsMappingNode, {
    retryPolicy: _constants.RETRY_POLICY
  }).addNode('extractColumnsFromEsql', extractColumnsFromEsqlNode, {
    retryPolicy: _constants.RETRY_POLICY
  }).addNode('correctColumnsFromMapping', correctColumnsFromMappingNode, {
    retryPolicy: _constants.RETRY_POLICY
  }).addNode('selectIndexPattern', selectIndexPatternNode).addNode('translationResult', translationResultNode)

  // Edges
  .addEdge(_langgraph.START, 'inlineQuery').addConditionalEdges('inlineQuery', translatableRouter, ['translateQuery', 'translationResult']).addEdge('translateQuery', 'validation').addEdge('fixQueryErrors', 'validation').addEdge('ecsMapping', 'validation').addConditionalEdges('validation', validationRouter, ['fixQueryErrors', 'ecsMapping', 'selectIndexPattern']).addEdge('selectIndexPattern', 'getIndexMapping').addEdge('getIndexMapping', 'correctColumnsFromMapping').addEdge('correctColumnsFromMapping', 'extractColumnsFromEsql').addEdge('extractColumnsFromEsql', 'translationResult').addEdge('translationResult', _langgraph.END);
  const graph = translateDashboardPanelGraph.compile();
  graph.name = 'Translate Dashboard Panel Graph';
  return graph;
}
const translatableRouter = state => {
  if (!state.inline_query) {
    return 'translationResult';
  }
  return 'translateQuery';
};
const validationRouter = state => {
  var _state$validation_err;
  if (state.validation_errors.retries_left > 0 && !(0, _fp.isEmpty)((_state$validation_err = state.validation_errors) === null || _state$validation_err === void 0 ? void 0 : _state$validation_err.esql_errors)) {
    return 'fixQueryErrors';
  }
  if (!state.includes_ecs_mapping) {
    return 'ecsMapping';
  }
  return 'selectIndexPattern';
};