"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dsl = void 0;
var _dsl_queries = require("../../common/data/dsl_queries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dsl = exports.dsl = {
  matchElasticTitle(title) {
    return {
      match: {
        'elastic_dashboard.title': title
      }
    };
  },
  matchOriginalTitle(title) {
    return {
      match: {
        'original_dashboard.title': title
      }
    };
  },
  matchTitle(title) {
    return {
      bool: {
        should: [
        // Match the translated title
        dsl.matchElasticTitle(title),
        // If translation failed, match the original title
        {
          bool: {
            must: [_dsl_queries.dsl.isFailed(), dsl.matchOriginalTitle(title)]
          }
        }]
      }
    };
  },
  isInstalled() {
    return {
      exists: {
        field: 'elastic_dashboard.id'
      }
    };
  },
  isNotInstalled() {
    return {
      bool: {
        must_not: dsl.isInstalled()
      }
    };
  },
  isInstallable() {
    return {
      bool: {
        must: [_dsl_queries.dsl.isFullOrPartiallyTranslated(), dsl.isNotInstalled()]
      }
    };
  },
  isNotInstallable() {
    return {
      bool: {
        should: [_dsl_queries.dsl.isNotFullOrPartiallyTranslated(), dsl.isInstalled()]
      }
    };
  }
};