"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemDashboardMigrationsRoutes = void 0;
var _create = require("./create");
var _create2 = require("./dashboards/create");
var _stats = require("./stats");
var _get = require("./get");
var _update = require("./update");
var _start = require("./start");
var _stop = require("./stop");
var _evaluate = require("./evaluation/evaluate");
var _missing = require("./resources/missing");
var _stats_all = require("./stats_all");
var _translation_stats = require("./translation_stats");
var _get2 = require("./resources/get");
var _upsert = require("./resources/upsert");
var _install = require("./install");
var _get3 = require("./dashboards/get");
var _delete = require("./delete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemDashboardMigrationsRoutes = (router, config, logger) => {
  // ===== Dashboard Migrations ======
  (0, _create.registerSiemDashboardMigrationsCreateRoute)(router, logger);
  (0, _get.registerSiemDashboardMigrationsGetRoute)(router, logger);
  (0, _update.registerSiemDashboardMigrationsUpdateRoute)(router, logger);
  (0, _delete.registerSiemDashboardMigrationsDeleteRoute)(router, logger);

  // ===== Dashboards ======
  (0, _create2.registerSiemDashboardMigrationsCreateDashboardsRoute)(router, logger);
  (0, _get3.registerSiemDashboardMigrationsGetDashboardsRoute)(router, logger);

  // ===== Resources ======
  (0, _missing.registerSiemDashboardMigrationsResourceGetMissingRoute)(router, logger);
  (0, _get2.registerSiemDashboardMigrationsResourceGetRoute)(router, logger);
  (0, _upsert.registerSiemDashboardMigrationsResourceUpsertRoute)(router, logger);

  // ===== Install ======
  (0, _install.registerSiemDashboardMigrationsInstallRoute)(router, logger);

  // ===== Stats ========
  (0, _stats.registerSiemDashboardMigrationsStatsRoute)(router, logger);
  (0, _stats_all.registerSiemDashboardMigrationsStatsAllRoute)(router, logger);
  (0, _translation_stats.registerSiemDashboardMigrationsTranslationStatsRoute)(router, logger);

  // ===== Task ========
  (0, _start.registerSiemDashboardMigrationsStartRoute)(router, logger);
  (0, _stop.registerSiemDashboardMigrationsStopRoute)(router, logger);
  if (config.experimentalFeatures.assistantModelEvaluation) {
    // Use the same experimental feature flag as the assistant model evaluation.
    // This route is not intended to be used by the end user, but rather for internal purposes.
    (0, _evaluate.registerSiemDashboardMigrationsEvaluateRoute)(router, logger);
  }
};
exports.registerSiemDashboardMigrationsRoutes = registerSiemDashboardMigrationsRoutes;