"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemDashboardMigrationsCreateRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _constants = require("../../../../../common/siem_migrations/dashboards/constants");
var _authz = require("../../common/api/util/authz");
var _dashboard_migration = require("../../../../../common/siem_migrations/model/api/dashboards/dashboard_migration.gen");
var _with_license = require("../../common/api/util/with_license");
var _audit = require("../../common/api/util/audit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemDashboardMigrationsCreateRoute = (router, logger) => {
  router.versioned.put({
    path: _constants.SIEM_DASHBOARD_MIGRATIONS_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_dashboard_migration.CreateDashboardMigrationRequestBody)
      }
    }
  }, (0, _with_license.withLicense)(async (context, req, res) => {
    const siemMigrationAuditLogger = new _audit.SiemMigrationAuditLogger(context.securitySolution, 'dashboards');
    try {
      const ctx = await context.resolve(['securitySolution']);
      const dashboardMigrationsClient = ctx.securitySolution.siemMigrations.getDashboardsClient();
      await siemMigrationAuditLogger.logCreateMigration();
      const migrationId = await dashboardMigrationsClient.data.migrations.create(req.body.name);
      return res.ok({
        body: {
          migration_id: migrationId
        }
      });
    } catch (error) {
      logger.error(error);
      await siemMigrationAuditLogger.logCreateMigration({
        error
      });
      return res.badRequest({
        body: error.message
      });
    }
  }));
};
exports.registerSiemDashboardMigrationsCreateRoute = registerSiemDashboardMigrationsCreateRoute;