"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsClientChat = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Using the inference chat model class, which extends from LangChain's `BaseChatModel` */

class ActionsClientChat {
  constructor(request, dependencies) {
    this.request = request;
    this.dependencies = dependencies;
  }
  async createModel({
    migrationId,
    migrationType,
    connectorId,
    abortController
  }) {
    const {
      inferenceService
    } = this.dependencies;
    return inferenceService.getChatModel({
      request: this.request,
      connectorId,
      chatModelOptions: {
        // not passing specific `model`, we'll always use the connector default model
        // temperature may need to be parametrized in the future
        temperature: 0.05,
        // Only retry once inside the model call, we already handle backoff retries in the task runner for the entire task
        maxRetries: 1,
        // Disable streaming explicitly
        disableStreaming: true,
        // Set a hard limit of 50 concurrent requests
        maxConcurrency: 50,
        telemetryMetadata: {
          pluginId: `${_constants.TELEMETRY_SIEM_MIGRATION_ID}_${migrationType}`,
          aggregateBy: migrationId
        },
        signal: abortController.signal
      }
    });
  }
  getModelName(model) {
    return model.identifyingParams().model_name;
  }
}
exports.ActionsClientChat = ActionsClientChat;