"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SiemMigrationTelemetryClient = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SiemMigrationTelemetryClient {
  constructor(telemetry, logger, migrationId, modelName = '') {
    this.telemetry = telemetry;
    this.logger = logger;
    this.migrationId = migrationId;
    this.modelName = modelName;
  }
  reportEvent(eventTypeOpts, data) {
    try {
      this.telemetry.reportEvent(eventTypeOpts.eventType, data);
    } catch (e) {
      this.logger.error(`Error reporting event ${eventTypeOpts.eventType}: ${e.message}`);
    }
  }
}
exports.SiemMigrationTelemetryClient = SiemMigrationTelemetryClient;