"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductFeatures = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _utils = require("@kbn/security-solution-features/utils");
var _product_features_config_merger = require("./product_features_config_merger");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ProductFeatures {
  constructor(logger) {
    (0, _defineProperty2.default)(this, "featuresSetup", void 0);
    (0, _defineProperty2.default)(this, "groupVersions", void 0);
    (0, _defineProperty2.default)(this, "registeredActions", void 0);
    this.logger = logger;
    this.groupVersions = new Map();
    this.registeredActions = new Set();
  }
  create(featureGroup, versions) {
    this.groupVersions.set(featureGroup, versions);
  }
  init(featuresSetup) {
    this.featuresSetup = featuresSetup;
  }
  register(enabledProductFeatureKeys, extensions = {}) {
    if (this.featuresSetup == null) {
      throw new Error('Cannot register product features. Service not initialized.');
    }
    const enabledKeys = new Set(enabledProductFeatureKeys);
    for (const [featureGroup, featureGroupVersions] of this.groupVersions.entries()) {
      var _extensions$featureGr;
      const {
        allVersions: allVersionsExtensions = {},
        version: versionsExtensions = {}
      } = (_extensions$featureGr = extensions[featureGroup]) !== null && _extensions$featureGr !== void 0 ? _extensions$featureGr : {};
      for (const featureVersion of featureGroupVersions) {
        var _versionsExtensions$f, _featureVersion$produ, _featureVersion$subFe, _featureVersion$baseK;
        const versionExtensions = (_versionsExtensions$f = versionsExtensions[featureVersion.baseKibanaFeature.id]) !== null && _versionsExtensions$f !== void 0 ? _versionsExtensions$f : {};
        const extendedConfig = (0, _utils.extendProductFeatureConfigs)((_featureVersion$produ = featureVersion.productFeatureConfig) !== null && _featureVersion$produ !== void 0 ? _featureVersion$produ : {}, allVersionsExtensions, versionExtensions);

        // Filter to include only the configs of enabled keys
        const filteredConfig = Object.entries(extendedConfig).reduce((acc, [key, value]) => {
          if (enabledKeys.has(key)) {
            acc.push(value);
          }
          return acc;
        }, []);
        const featureConfigMerger = new _product_features_config_merger.ProductFeaturesConfigMerger(this.logger, (_featureVersion$subFe = featureVersion.subFeaturesMap) !== null && _featureVersion$subFe !== void 0 ? _featureVersion$subFe : new Map());
        const completeProductFeatureConfig = featureConfigMerger.mergeProductFeatureConfigs(featureVersion.baseKibanaFeature, (_featureVersion$baseK = featureVersion.baseKibanaSubFeatureIds) !== null && _featureVersion$baseK !== void 0 ? _featureVersion$baseK : [], filteredConfig);
        this.featuresSetup.registerKibanaFeature(completeProductFeatureConfig);
        this.addRegisteredActions(completeProductFeatureConfig);
      }
    }
  }
  addRegisteredActions(config) {
    var _config$privileges, _config$privileges3, _config$subFeatures;
    const privileges = [];

    // get main privileges
    if ((_config$privileges = config.privileges) !== null && _config$privileges !== void 0 && _config$privileges.all) {
      var _config$privileges2;
      privileges.push((_config$privileges2 = config.privileges) === null || _config$privileges2 === void 0 ? void 0 : _config$privileges2.all);
    }
    if ((_config$privileges3 = config.privileges) !== null && _config$privileges3 !== void 0 && _config$privileges3.read) {
      var _config$privileges4;
      privileges.push((_config$privileges4 = config.privileges) === null || _config$privileges4 === void 0 ? void 0 : _config$privileges4.read);
    }

    // get sub features privileges
    (_config$subFeatures = config.subFeatures) === null || _config$subFeatures === void 0 ? void 0 : _config$subFeatures.forEach(subFeature => {
      subFeature.privilegeGroups.forEach(privilegeGroup => {
        privilegeGroup.privileges.forEach(privilege => {
          privileges.push(privilege);
        });
      });
    });

    // add the actions from all the registered privileges
    privileges.forEach(privilege => {
      var _privilege$api, _privilege$ui;
      (_privilege$api = privilege.api) === null || _privilege$api === void 0 ? void 0 : _privilege$api.forEach(apiAction => {
        this.registeredActions.add(`api:${apiAction}`);
      });
      (_privilege$ui = privilege.ui) === null || _privilege$ui === void 0 ? void 0 : _privilege$ui.forEach(uiAction => {
        this.registeredActions.add(`ui:${uiAction}`);
      });
    });
  }
  isActionRegistered(action) {
    return this.registeredActions.has(action);
  }
}
exports.ProductFeatures = ProductFeatures;