"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPainlessScripts = void 0;
var _fs = _interopRequireDefault(require("fs"));
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PHASES = ['init', 'map', 'combine', 'reduce'];
const removeNewlines = content => content.replace(/\n/g, '');
const condenseMultipleSpaces = content => content.replace(/\s+/g, ' ');
const removeComments = content => content.replace(/\/\/.*/g, '');
const minifyContent = (0, _lodash.flow)(removeComments, removeNewlines, condenseMultipleSpaces);
const readScript = async phase => {
  const content = await _fs.default.promises.readFile(`${__dirname}/risk_scoring_${phase}.painless`, 'utf8');
  return minifyContent(content);
};
let cache;
const getPainlessScripts = async () => {
  if (cache) {
    return cache;
  }
  const [init, map, combine, reduce] = await Promise.all(PHASES.map(readScript));

  // The cache will only ever have one value, so we can safely update it
  // un-atomicly without worrying about lost updates.
  // eslint-disable-next-line require-atomic-updates
  cache = {
    init,
    map,
    combine,
    reduce
  };
  return cache;
};
exports.getPainlessScripts = getPainlessScripts;