"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteUsersWithSourceIndexFactory = void 0;
var _utils = require("../../../../../../common/entity_analytics/privileged_user_monitoring/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteUsersWithSourceIndexFactory = deps => async namespace => {
  // Delete all users that don't have the id defined
  await deps.esClient.deleteByQuery({
    index: (0, _utils.getPrivilegedMonitorUsersIndex)(namespace),
    refresh: true,
    conflicts: 'proceed',
    ignore_unavailable: true,
    allow_no_indices: true,
    query: {
      bool: {
        must: [{
          exists: {
            field: 'labels.source_indices'
          }
        }]
      }
    }
  });
};
exports.deleteUsersWithSourceIndexFactory = deleteUsersWithSourceIndexFactory;