"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkandInitPrivilegeMonitoringResourcesNoContext = exports.checkAndInitPrivilegeMonitoringResources = void 0;
var _indices = require("./engine/elasticsearch/indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * As internal user we check for existence of privilege monitoring resources
 * and initialise it if it does not exist
 * @param context
 * @param logger
 */
const checkAndInitPrivilegeMonitoringResources = async (context, logger) => {
  const securityContext = await context.securitySolution;
  const privilegeMonitoringDataClient = securityContext.getPrivilegeMonitoringDataClient();
  const privmonIndexService = (0, _indices.createPrivmonIndexService)(privilegeMonitoringDataClient);
  await checkandInitPrivilegeMonitoringResourcesNoContext(privmonIndexService, logger);
};
exports.checkAndInitPrivilegeMonitoringResources = checkAndInitPrivilegeMonitoringResources;
const checkandInitPrivilegeMonitoringResourcesNoContext = async (privmonIndexService, logger) => {
  const doesIndexExist = await privmonIndexService.doesIndexExist();
  if (!doesIndexExist) {
    logger.info('Privilege monitoring resources are not installed, initialising...');
    await privmonIndexService.initialisePrivmonIndex();
    logger.info('Privilege monitoring resources installed');
  }
};
exports.checkandInitPrivilegeMonitoringResourcesNoContext = checkandInitPrivilegeMonitoringResourcesNoContext;