"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CapabilityNotEnabledError = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CapabilityNotEnabledError extends Error {
  constructor(capability) {
    super(`Capability ${capability} not enabled on this cluster. Please restart entity store `);
  }
}
exports.CapabilityNotEnabledError = CapabilityNotEnabledError;