"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRemoveEmptyFieldSteps = void 0;
var _painless = require("../../painless");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This function creates an ingest processor step that removes a field if it is missing or empty.
 */
const getRemoveEmptyFieldSteps = fields => fields.map(field => {
  return {
    remove: {
      if: (0, _painless.isFieldMissingOrEmpty)(`ctx.${field}`),
      field,
      ignore_missing: true
    }
  };
});
exports.getRemoveEmptyFieldSteps = getRemoveEmptyFieldSteps;