"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIsAlertSuppressionActive = exports.alertSuppressionTypeGuard = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertSuppressionTypeGuard = alertSuppression => {
  var _alertSuppression$gro;
  return Boolean(alertSuppression === null || alertSuppression === void 0 ? void 0 : (_alertSuppression$gro = alertSuppression.groupBy) === null || _alertSuppression$gro === void 0 ? void 0 : _alertSuppression$gro.length);
};

/**
 * checks if alert suppression is active:
 * - rule should have alert suppression config
 * - feature flag should not be disabled
 * - license should be platinum
 */
exports.alertSuppressionTypeGuard = alertSuppressionTypeGuard;
const getIsAlertSuppressionActive = async ({
  licensing,
  alertSuppression,
  isFeatureDisabled = false
}) => {
  if (isFeatureDisabled) {
    return false;
  }
  const isAlertSuppressionConfigured = alertSuppressionTypeGuard(alertSuppression);
  if (!isAlertSuppressionConfigured) {
    return false;
  }
  const license = await (0, _rxjs.firstValueFrom)(licensing.license$);
  const hasPlatinumLicense = license.hasAtLeast('platinum');
  return hasPlatinumLicense;
};
exports.getIsAlertSuppressionActive = getIsAlertSuppressionActive;