"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.enrichEvents = void 0;
var _host_risk = require("./enrichment_by_type/host_risk");
var _user_risk = require("./enrichment_by_type/user_risk");
var _asset_criticality = require("./enrichment_by_type/asset_criticality");
var _asset_criticality2 = require("../../../../../../common/entity_analytics/asset_criticality");
var _transforms = require("./utils/transforms");
var _is_index_exist = require("./utils/is_index_exist");
var _search_strategy = require("../../../../../../common/search_strategy");
var _service_risk = require("./enrichment_by_type/service_risk");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const enrichEvents = async ({
  services,
  logger,
  events,
  spaceId
}) => {
  try {
    const enrichments = [];
    logger.debug('Alert enrichments started');
    const isRiskScoreIndexExist = await (0, _is_index_exist.isIndexExist)({
      services,
      index: (0, _search_strategy.getRiskIndex)(spaceId, true)
    });
    if (isRiskScoreIndexExist) {
      enrichments.push((0, _host_risk.createHostRiskEnrichments)({
        services,
        logger,
        events,
        spaceId
      }));
      enrichments.push((0, _user_risk.createUserRiskEnrichments)({
        services,
        logger,
        events,
        spaceId
      }));
      enrichments.push((0, _service_risk.createServiceRiskEnrichments)({
        services,
        logger,
        events,
        spaceId
      }));
    }
    const assetCriticalityIndexExist = await (0, _is_index_exist.isIndexExist)({
      services,
      index: (0, _asset_criticality2.getAssetCriticalityIndex)(spaceId)
    });
    if (assetCriticalityIndexExist) {
      enrichments.push((0, _asset_criticality.createUserAssetCriticalityEnrichments)({
        services,
        logger,
        events,
        spaceId
      }));
      enrichments.push((0, _asset_criticality.createHostAssetCriticalityEnrichments)({
        services,
        logger,
        events,
        spaceId
      }));
      enrichments.push((0, _asset_criticality.createServiceAssetCriticalityEnrichments)({
        services,
        logger,
        events,
        spaceId
      }));
    }
    const allEnrichmentsResults = await Promise.allSettled(enrichments);
    const allFulfilledEnrichmentsResults = allEnrichmentsResults.filter(result => result.status === 'fulfilled').map(result => result === null || result === void 0 ? void 0 : result.value);
    return (0, _transforms.applyEnrichmentsToEvents)({
      events,
      enrichmentsList: allFulfilledEnrichmentsResults,
      logger
    });
  } catch (error) {
    logger.error(`Enrichments failed ${error}`);
    return events;
  }
};
exports.enrichEvents = enrichEvents;