"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.queryExecutor = void 0;
var _rxjs = require("rxjs");
var _get_filter = require("../utils/get_filter");
var _group_and_bulk_create = require("./alert_suppression/group_and_bulk_create");
var _search_after_bulk_create = require("../utils/search_after_bulk_create");
var _reason_formatters = require("../utils/reason_formatters");
var _with_security_span = require("../../../../utils/with_security_span");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const queryExecutor = async ({
  sharedParams,
  eventsTelemetry,
  services,
  bucketHistory,
  scheduleNotificationResponseActionsService,
  licensing,
  isLoggedRequestsEnabled
}) => {
  const {
    completeRule
  } = sharedParams;
  const ruleParams = completeRule.ruleParams;
  return (0, _with_security_span.withSecuritySpan)('queryExecutor', async () => {
    var _ruleParams$alertSupp;
    const esFilter = await (0, _get_filter.getFilter)({
      type: ruleParams.type,
      filters: ruleParams.filters,
      language: ruleParams.language,
      query: ruleParams.query,
      savedId: ruleParams.savedId,
      services,
      index: sharedParams.inputIndex,
      exceptionFilter: sharedParams.exceptionFilter,
      loadFields: true
    });
    const license = await (0, _rxjs.firstValueFrom)(licensing.license$);
    const hasPlatinumLicense = license.hasAtLeast('platinum');
    const result =
    // TODO: replace this with getIsAlertSuppressionActive function
    ((_ruleParams$alertSupp = ruleParams.alertSuppression) === null || _ruleParams$alertSupp === void 0 ? void 0 : _ruleParams$alertSupp.groupBy) != null && hasPlatinumLicense ? await (0, _group_and_bulk_create.groupAndBulkCreate)({
      sharedParams,
      services,
      filter: esFilter,
      buildReasonMessage: _reason_formatters.buildReasonMessageForQueryAlert,
      bucketHistory,
      groupByFields: ruleParams.alertSuppression.groupBy,
      eventsTelemetry,
      isLoggedRequestsEnabled
    }) : {
      ...(await (0, _search_after_bulk_create.searchAfterAndBulkCreate)({
        sharedParams,
        services,
        eventsTelemetry,
        filter: esFilter,
        buildReasonMessage: _reason_formatters.buildReasonMessageForQueryAlert,
        isLoggedRequestsEnabled
      })),
      state: {
        isLoggedRequestsEnabled
      }
    };
    scheduleNotificationResponseActionsService({
      signals: result.createdSignals,
      signalsCount: result.createdSignalsCount,
      responseActions: completeRule.ruleParams.responseActions
    });
    return result;
  });
};
exports.queryExecutor = queryExecutor;