"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rowToDocument = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * transform ES|QL result row to JSON object
 * @param columns
 * @param row
 * @returns Record<string, string | null>
 */
const rowToDocument = (columns, row) => {
  return columns.reduce((acc, column, i) => {
    const cell = row[i];
    // skips nulls, as ES|QL return null for each existing mapping field
    if (cell !== null) {
      acc[column.name] = cell;
    }
    return acc;
  }, {});
};
exports.rowToDocument = rowToDocument;