"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setAlertAssigneesRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _fp = require("lodash/fp");
var _zodHelpers = require("@kbn/zod-helpers");
var _alert_assignees = require("../../../../../common/api/detection_engine/alert_assignees");
var _constants = require("../../../../../common/constants");
var _utils = require("../utils");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setAlertAssigneesRoute = router => {
  router.versioned.post({
    path: _constants.DETECTION_ENGINE_ALERT_ASSIGNEES_URL,
    access: 'public',
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    }
  }).addVersion({
    version: '2023-10-31',
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_alert_assignees.SetAlertAssigneesRequestBody)
      }
    }
  }, async (context, request, response) => {
    var _securitySolution$get;
    const {
      assignees,
      ids
    } = request.body;
    const core = await context.core;
    const securitySolution = await context.securitySolution;
    const esClient = core.elasticsearch.client.asCurrentUser;
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const validationErrors = (0, _helpers.validateAlertAssigneesArrays)(assignees);
    const spaceId = (_securitySolution$get = securitySolution === null || securitySolution === void 0 ? void 0 : securitySolution.getSpaceId()) !== null && _securitySolution$get !== void 0 ? _securitySolution$get : 'default';
    if (validationErrors.length) {
      return siemResponse.error({
        statusCode: 400,
        body: validationErrors
      });
    }
    const assigneesToAdd = (0, _fp.uniq)(assignees.add);
    const assigneesToRemove = (0, _fp.uniq)(assignees.remove);
    const painlessScript = {
      params: {
        assigneesToAdd,
        assigneesToRemove
      },
      source: `List newAssigneesArray = [];
        if (ctx._source["kibana.alert.workflow_assignee_ids"] != null) {
          for (assignee in ctx._source["kibana.alert.workflow_assignee_ids"]) {
            if (!params.assigneesToRemove.contains(assignee)) {
              newAssigneesArray.add(assignee);
            }
          }
          for (assignee in params.assigneesToAdd) {
            if (!newAssigneesArray.contains(assignee)) {
              newAssigneesArray.add(assignee)
            }
          }
          ctx._source["kibana.alert.workflow_assignee_ids"] = newAssigneesArray;
        } else {
          ctx._source["kibana.alert.workflow_assignee_ids"] = params.assigneesToAdd;
        }
        `,
      lang: 'painless'
    };
    const bulkUpdateRequest = [];
    for (const id of ids) {
      bulkUpdateRequest.push({
        update: {
          _index: `${_constants.DEFAULT_ALERTS_INDEX}-${spaceId}`,
          _id: id
        }
      }, {
        script: painlessScript
      });
    }
    try {
      const body = await esClient.updateByQuery({
        index: `${_constants.DEFAULT_ALERTS_INDEX}-${spaceId}`,
        refresh: true,
        script: painlessScript,
        query: {
          bool: {
            filter: {
              terms: {
                _id: ids
              }
            }
          }
        }
      });
      return response.ok({
        body
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.setAlertAssigneesRoute = setAlertAssigneesRoute;