"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.orderAgnosticArrayDiffAlgorithm = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const orderAgnosticArrayDiffAlgorithm = (a, b) => {
  // Converts to Sets to compare agnostic of order
  return (0, _lodash.isEqual)(new Set(a), new Set(b));
};
exports.orderAgnosticArrayDiffAlgorithm = orderAgnosticArrayDiffAlgorithm;