"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortIntegrationsByStatus = sortIntegrationsByStatus;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Sorts integrations in place
 */
function sortIntegrationsByStatus(integration) {
  integration.sort((a, b) => {
    if (a.is_enabled && !b.is_enabled) {
      return -1;
    } else if (!a.is_enabled && b.is_enabled) {
      return 1;
    }
    if (a.is_installed && !b.is_installed) {
      return -1;
    } else if (!a.is_installed && b.is_installed) {
      return 1;
    }
    return 0;
  });
}