"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrappedTranslatedExceptionList = exports.translatedPerformantEntries = exports.translatedExceptionListItem = exports.translatedEntryNestedEntry = exports.translatedEntryNested = exports.translatedEntryMatcher = exports.translatedEntryMatchWildcardNameMatcher = exports.translatedEntryMatchWildcardName = exports.translatedEntryMatchWildcardMatcher = exports.translatedEntryMatchWildcard = exports.translatedEntryMatchMatcher = exports.translatedEntryMatchAnyMatcher = exports.translatedEntryMatchAny = exports.translatedEntryMatch = exports.translatedEntryDescendantOf = exports.translatedEntry = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const translatedEntryMatchAnyMatcher = exports.translatedEntryMatchAnyMatcher = t.keyof({
  exact_cased_any: null,
  exact_caseless_any: null
});
const translatedEntryMatchAny = exports.translatedEntryMatchAny = t.exact(t.type({
  field: t.string,
  operator: _securitysolutionIoTsListTypes.listOperator,
  type: translatedEntryMatchAnyMatcher,
  value: t.array(t.string)
}));
const translatedEntryMatchMatcher = exports.translatedEntryMatchMatcher = t.keyof({
  exact_cased: null,
  exact_caseless: null
});
const translatedEntryMatchWildcardMatcher = exports.translatedEntryMatchWildcardMatcher = t.keyof({
  wildcard_cased: null,
  wildcard_caseless: null
});
const translatedEntryMatchWildcard = exports.translatedEntryMatchWildcard = t.exact(t.type({
  field: t.string,
  operator: _securitysolutionIoTsListTypes.listOperator,
  type: translatedEntryMatchWildcardMatcher,
  value: t.string
}));
const translatedEntryMatchWildcardNameMatcher = exports.translatedEntryMatchWildcardNameMatcher = t.keyof({
  exact_cased: null,
  exact_caseless: null
});
const translatedEntryMatchWildcardName = exports.translatedEntryMatchWildcardName = t.exact(t.type({
  field: t.string,
  operator: _securitysolutionIoTsListTypes.listOperator,
  type: translatedEntryMatchWildcardNameMatcher,
  value: t.string
}));
const translatedEntryMatch = exports.translatedEntryMatch = t.exact(t.type({
  field: t.string,
  operator: _securitysolutionIoTsListTypes.listOperator,
  type: translatedEntryMatchMatcher,
  value: t.string
}));
const translatedEntryMatcher = exports.translatedEntryMatcher = t.union([translatedEntryMatchMatcher, translatedEntryMatchAnyMatcher]);
const translatedEntryNestedEntry = exports.translatedEntryNestedEntry = t.union([translatedEntryMatch, translatedEntryMatchAny]);
const translatedEntryNested = exports.translatedEntryNested = t.exact(t.type({
  field: t.string,
  type: t.keyof({
    nested: null
  }),
  entries: t.array(translatedEntryNestedEntry)
}));
const translatedEntriesOfDescendantOf = t.type({
  type: t.string,
  entries: t.array(t.union([translatedEntryNested, translatedEntryMatch, translatedEntryMatchWildcard, translatedEntryMatchAny]))
});
const translatedEntryDescendantOf = exports.translatedEntryDescendantOf = t.exact(t.type({
  operator: _securitysolutionIoTsListTypes.listOperator,
  type: t.keyof({
    descendent_of: null
  }),
  value: t.type({
    entries: t.array(translatedEntriesOfDescendantOf)
  })
}));
const translatedEntry = exports.translatedEntry = t.union([translatedEntryNested, translatedEntryMatch, translatedEntryMatchWildcard, translatedEntryMatchAny, translatedEntryDescendantOf]);
const translatedPerformantEntries = exports.translatedPerformantEntries = t.array(t.union([translatedEntryMatchWildcard, translatedEntryMatchWildcardName]));
const translatedExceptionListItem = exports.translatedExceptionListItem = t.exact(t.type({
  type: t.string,
  entries: t.array(translatedEntry)
}));
const wrappedTranslatedExceptionList = exports.wrappedTranslatedExceptionList = t.exact(t.type({
  entries: t.array(translatedExceptionListItem)
}));