"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotFoundError = exports.EndpointAuthorizationError = exports.EndpointAppContentServicesNotStartedError = exports.EndpointAppContentServicesNotSetUpError = exports.ENDPOINT_AUTHZ_ERROR_MESSAGE = void 0;
var _i18n = require("@kbn/i18n");
var _errors = require("../../common/endpoint/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable max-classes-per-file */

const ENDPOINT_AUTHZ_ERROR_MESSAGE = exports.ENDPOINT_AUTHZ_ERROR_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.errors.noEndpointAuthzApiErrorMessage', {
  defaultMessage: 'Endpoint authorization failure'
});
class NotFoundError extends _errors.EndpointError {}
exports.NotFoundError = NotFoundError;
class EndpointAppContentServicesNotSetUpError extends _errors.EndpointError {
  constructor() {
    super('EndpointAppContextService has not been set up (EndpointAppContextService.setup())');
  }
}
exports.EndpointAppContentServicesNotSetUpError = EndpointAppContentServicesNotSetUpError;
class EndpointAppContentServicesNotStartedError extends _errors.EndpointError {
  constructor() {
    super('EndpointAppContextService has not been started (EndpointAppContextService.start())');
  }
}
exports.EndpointAppContentServicesNotStartedError = EndpointAppContentServicesNotStartedError;
class EndpointAuthorizationError extends _errors.EndpointError {
  constructor(meta) {
    super(ENDPOINT_AUTHZ_ERROR_MESSAGE, meta);
  }
}
exports.EndpointAuthorizationError = EndpointAuthorizationError;