"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointAppContextService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/spaces-plugin/common");
var _errors = require("../../common/endpoint/errors");
var _reference_data = require("./lib/reference_data");
var _saved_objects = require("./services/saved_objects");
var _services = require("./services");
var _fleet_integration = require("../fleet_integration/fleet_integration");
var _metadata = require("./services/metadata");
var _errors2 = require("./errors");
var _endpoint_fleet_services_factory = require("./services/fleet/endpoint_fleet_services_factory");
var _lists_integration = require("../lists_integration");
var _authz = require("../../common/endpoint/service/authz");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A singleton that holds shared services that are initialized during the start up phase
 * of the plugin lifecycle. And stop during the stop phase, if needed.
 */
class EndpointAppContextService {
  constructor() {
    (0, _defineProperty2.default)(this, "setupDependencies", null);
    (0, _defineProperty2.default)(this, "startDependencies", null);
    (0, _defineProperty2.default)(this, "fleetServicesFactory", null);
    (0, _defineProperty2.default)(this, "savedObjectsFactoryService", null);
    (0, _defineProperty2.default)(this, "security", void 0);
  }
  setup(dependencies) {
    this.setupDependencies = dependencies;
  }
  start(dependencies) {
    if (!this.setupDependencies) {
      throw new _errors2.EndpointAppContentServicesNotSetUpError();
    }
    const savedObjectsFactory = new _saved_objects.SavedObjectsClientFactory(dependencies.savedObjectsServiceStart, this.setupDependencies.httpServiceSetup);
    this.startDependencies = dependencies;
    this.security = dependencies.security;
    this.savedObjectsFactoryService = savedObjectsFactory;
    this.fleetServicesFactory = new _endpoint_fleet_services_factory.EndpointFleetServicesFactory(dependencies.fleetStartServices, savedObjectsFactory, this.createLogger('endpointFleetServices'));
    this.registerFleetExtensions();
    this.registerListsExtensions();
  }
  stop() {
    this.startDependencies = null;
    this.savedObjectsFactoryService = null;
  }
  registerListsExtensions() {
    var _this$startDependenci;
    if ((_this$startDependenci = this.startDependencies) !== null && _this$startDependenci !== void 0 && _this$startDependenci.registerListsServerExtension) {
      var _this$startDependenci2;
      (0, _lists_integration.registerListsPluginEndpointExtensionPoints)((_this$startDependenci2 = this.startDependencies) === null || _this$startDependenci2 === void 0 ? void 0 : _this$startDependenci2.registerListsServerExtension, this);
    }
  }
  registerFleetExtensions() {
    if (!this.setupDependencies) {
      throw new _errors2.EndpointAppContentServicesNotSetUpError();
    }
    if (!this.startDependencies) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    const {
      fleetStartServices: {
        registerExternalCallback: registerFleetCallback
      },
      manifestManager,
      alerting,
      licenseService,
      telemetryConfigProvider,
      productFeaturesService,
      experimentalFeatures
    } = this.startDependencies;
    const logger = this.createLogger('endpointFleetExtension');
    registerFleetCallback('agentPolicyCreate', (0, _fleet_integration.getAgentPolicyCreateCallback)(logger, productFeaturesService));
    registerFleetCallback('agentPolicyUpdate', (0, _fleet_integration.getAgentPolicyUpdateCallback)(logger, productFeaturesService));
    registerFleetCallback('agentPolicyPostUpdate', (0, _fleet_integration.getAgentPolicyPostUpdateCallback)(this));
    registerFleetCallback('packagePolicyCreate', (0, _fleet_integration.getPackagePolicyCreateCallback)(logger, manifestManager, this.setupDependencies.securitySolutionRequestContextFactory, alerting, licenseService, this.setupDependencies.cloud, productFeaturesService, telemetryConfigProvider, experimentalFeatures));
    registerFleetCallback('packagePolicyPostCreate', (0, _fleet_integration.getPackagePolicyPostCreateCallback)(this));
    registerFleetCallback('packagePolicyUpdate', (0, _fleet_integration.getPackagePolicyUpdateCallback)(this, this.setupDependencies.cloud, productFeaturesService, experimentalFeatures));
    registerFleetCallback('packagePolicyPostUpdate', (0, _fleet_integration.getPackagePolicyPostUpdateCallback)(this));
    registerFleetCallback('packagePolicyPostDelete', (0, _fleet_integration.getPackagePolicyDeleteCallback)(this));
  }

  /**
   * Property providing access to saved objects client factory
   */
  get savedObjects() {
    if (!this.savedObjectsFactoryService) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    return this.savedObjectsFactoryService;
  }

  /**
   * Is kibana running in serverless mode
   */
  isServerless() {
    if (!this.setupDependencies) {
      throw new _errors2.EndpointAppContentServicesNotSetUpError();
    }

    // TODO:PT check what this returns when running locally with kibana in serverless emulation

    return Boolean(this.setupDependencies.cloud.isServerlessEnabled);
  }
  getInternalEsClient() {
    var _this$startDependenci3;
    if (!((_this$startDependenci3 = this.startDependencies) !== null && _this$startDependenci3 !== void 0 && _this$startDependenci3.esClient)) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    return this.startDependencies.esClient;
  }
  getFleetAuthzService() {
    var _this$startDependenci4;
    if (!((_this$startDependenci4 = this.startDependencies) !== null && _this$startDependenci4 !== void 0 && _this$startDependenci4.fleetStartServices)) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    return this.startDependencies.fleetStartServices.authz;
  }
  createLogger(...contextParts) {
    var _this$setupDependenci;
    if (!((_this$setupDependenci = this.setupDependencies) !== null && _this$setupDependenci !== void 0 && _this$setupDependenci.loggerFactory)) {
      throw new _errors2.EndpointAppContentServicesNotSetUpError();
    }
    return this.setupDependencies.loggerFactory.get(...contextParts);
  }
  async getEndpointAuthz(request) {
    var _this$startDependenci5, _this$security$authc$, _this$security, _this$security$authc$2;
    if (!((_this$startDependenci5 = this.startDependencies) !== null && _this$startDependenci5 !== void 0 && _this$startDependenci5.productFeaturesService)) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    const fleetAuthz = await this.getFleetAuthzService().fromRequest(request);
    const userRoles = (_this$security$authc$ = (_this$security = this.security) === null || _this$security === void 0 ? void 0 : (_this$security$authc$2 = _this$security.authc.getCurrentUser(request)) === null || _this$security$authc$2 === void 0 ? void 0 : _this$security$authc$2.roles) !== null && _this$security$authc$ !== void 0 ? _this$security$authc$ : [];
    return (0, _authz.calculateEndpointAuthz)(this.getLicenseService(), fleetAuthz, userRoles, this.startDependencies.productFeaturesService);
  }
  getEndpointMetadataService(spaceId = _common.DEFAULT_SPACE_ID) {
    if (this.startDependencies == null) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    const spaceIdValue = this.experimentalFeatures.endpointManagementSpaceAwarenessEnabled ? spaceId : _common.DEFAULT_SPACE_ID;
    return new _metadata.EndpointMetadataService(this.startDependencies.esClient, this.savedObjects.createInternalScopedSoClient({
      readonly: false,
      spaceId: spaceIdValue
    }), this.getInternalFleetServices(spaceIdValue), this.createLogger('endpointMetadata'));
  }

  /**
   * SpaceId should be defined if wanting go get back an internal client that is scoped to a given space id
   * @param spaceId
   * @param unscoped
   */
  getInternalFleetServices(spaceId, unscoped = false) {
    if (this.fleetServicesFactory === null) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    return this.fleetServicesFactory.asInternalUser(this.experimentalFeatures.endpointManagementSpaceAwarenessEnabled ? spaceId : undefined, unscoped);
  }
  getManifestManager() {
    var _this$startDependenci6;
    return (_this$startDependenci6 = this.startDependencies) === null || _this$startDependenci6 === void 0 ? void 0 : _this$startDependenci6.manifestManager;
  }
  getLicenseService() {
    if (this.startDependencies == null) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    return this.startDependencies.licenseService;
  }
  async getCasesClient(req) {
    var _this$startDependenci7;
    if (((_this$startDependenci7 = this.startDependencies) === null || _this$startDependenci7 === void 0 ? void 0 : _this$startDependenci7.cases) == null) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    return this.startDependencies.cases.getCasesClientWithRequest(req);
  }
  getFeatureUsageService() {
    if (this.startDependencies == null) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    return this.startDependencies.featureUsageService;
  }
  get experimentalFeatures() {
    if (this.startDependencies == null) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    return this.startDependencies.experimentalFeatures;
  }
  getExceptionListsClient() {
    var _this$startDependenci8;
    if (!((_this$startDependenci8 = this.startDependencies) !== null && _this$startDependenci8 !== void 0 && _this$startDependenci8.exceptionListsClient)) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    return this.startDependencies.exceptionListsClient;
  }
  getMessageSigningService() {
    var _this$startDependenci9, _this$startDependenci10;
    if (!((_this$startDependenci9 = this.startDependencies) !== null && _this$startDependenci9 !== void 0 && _this$startDependenci9.fleetStartServices.messageSigningService)) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    return (_this$startDependenci10 = this.startDependencies) === null || _this$startDependenci10 === void 0 ? void 0 : _this$startDependenci10.fleetStartServices.messageSigningService;
  }
  getInternalResponseActionsClient({
    agentType = 'endpoint',
    username = 'elastic',
    taskId,
    taskType,
    spaceId
  }) {
    var _this$startDependenci11;
    if (!((_this$startDependenci11 = this.startDependencies) !== null && _this$startDependenci11 !== void 0 && _this$startDependenci11.esClient)) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    return (0, _services.getResponseActionsClient)(agentType, {
      endpointService: this,
      esClient: this.startDependencies.esClient,
      username,
      spaceId,
      isAutomated: true,
      connectorActions: new _services.NormalizedExternalConnectorClient(this.startDependencies.connectorActions.getUnsecuredActionsClient(), this.createLogger('responseActions'), {
        spaceId,
        relatedSavedObjects: taskId && taskType ? [{
          id: taskId,
          type: taskType
        }] : undefined
      })
    });
  }
  async getFleetToHostFilesClient() {
    var _this$startDependenci12;
    if (!((_this$startDependenci12 = this.startDependencies) !== null && _this$startDependenci12 !== void 0 && _this$startDependenci12.fleetStartServices)) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    return this.startDependencies.fleetStartServices.createFilesClient.toHost('endpoint', this.startDependencies.config.maxUploadResponseActionFileBytes);
  }
  async getFleetFromHostFilesClient() {
    var _this$startDependenci13;
    if (!((_this$startDependenci13 = this.startDependencies) !== null && _this$startDependenci13 !== void 0 && _this$startDependenci13.fleetStartServices)) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    return this.startDependencies.fleetStartServices.createFilesClient.fromHost('endpoint');
  }
  async getFleetActionsClient() {
    var _this$startDependenci14;
    if (!((_this$startDependenci14 = this.startDependencies) !== null && _this$startDependenci14 !== void 0 && _this$startDependenci14.fleetStartServices)) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    return this.startDependencies.fleetStartServices.createFleetActionsClient('endpoint');
  }
  getTelemetryService() {
    var _this$setupDependenci2;
    if (!((_this$setupDependenci2 = this.setupDependencies) !== null && _this$setupDependenci2 !== void 0 && _this$setupDependenci2.telemetry)) {
      throw new _errors2.EndpointAppContentServicesNotSetUpError();
    }
    return this.setupDependencies.telemetry;
  }
  getActiveSpace(httpRequest) {
    var _this$startDependenci15;
    if (!((_this$startDependenci15 = this.startDependencies) !== null && _this$startDependenci15 !== void 0 && _this$startDependenci15.spacesService)) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    return this.startDependencies.spacesService.getActiveSpace(httpRequest);
  }
  getReferenceDataClient() {
    var _this$startDependenci16;
    if (!((_this$startDependenci16 = this.startDependencies) !== null && _this$startDependenci16 !== void 0 && _this$startDependenci16.savedObjectsServiceStart)) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    return new _reference_data.ReferenceDataClient(this.savedObjects.createInternalScopedSoClient({
      readonly: false
    }), this.createLogger('ReferenceDataClient'));
  }
  getServerConfigValue(key) {
    var _this$startDependenci17;
    if (!((_this$startDependenci17 = this.startDependencies) !== null && _this$startDependenci17 !== void 0 && _this$startDependenci17.config)) {
      throw new _errors2.EndpointAppContentServicesNotStartedError();
    }
    if (!Object.prototype.hasOwnProperty.call(this.startDependencies.config, key)) {
      throw new _errors.EndpointError(`Missing config value for key: ${key}`);
    }
    return this.startDependencies.config[key];
  }
}
exports.EndpointAppContextService = EndpointAppContextService;