"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assistantTools = void 0;
var _product_documentation_tool = require("./product_docs/product_documentation_tool");
var _generate_esql_tool = require("./esql/generate_esql_tool");
var _ask_about_esql_tool = require("./esql/ask_about_esql_tool");
var _alert_counts_tool = require("./alert_counts/alert_counts_tool");
var _open_and_acknowledged_alerts_tool = require("./open_and_acknowledged_alerts/open_and_acknowledged_alerts_tool");
var _knowledge_base_retrieval_tool = require("./knowledge_base/knowledge_base_retrieval_tool");
var _knowledge_base_write_tool = require("./knowledge_base/knowledge_base_write_tool");
var _security_labs_tool = require("./security_labs/security_labs_tool");
var _entity_risk_score = require("./entity_risk_score/entity_risk_score");
var _integration_knowledge_tool = require("./integration_knowledge/integration_knowledge_tool");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// any new tool should also be added to telemetry schema in
// x-pack/solutions/security/plugins/elastic_assistant/server/lib/telemetry/event_based_telemetry.ts
const assistantTools = exports.assistantTools = [_alert_counts_tool.ALERT_COUNTS_TOOL, _knowledge_base_retrieval_tool.KNOWLEDGE_BASE_RETRIEVAL_TOOL, _knowledge_base_write_tool.KNOWLEDGE_BASE_WRITE_TOOL, _generate_esql_tool.GENERATE_ESQL_TOOL, _ask_about_esql_tool.ASK_ABOUT_ESQL_TOOL, _open_and_acknowledged_alerts_tool.OPEN_AND_ACKNOWLEDGED_ALERTS_TOOL, _product_documentation_tool.PRODUCT_DOCUMENTATION_TOOL, _security_labs_tool.SECURITY_LABS_KNOWLEDGE_BASE_TOOL, _entity_risk_score.ENTITY_RISK_SCORE_TOOL, _integration_knowledge_tool.INTEGRATION_KNOWLEDGE_TOOL];