"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNlToEsqlAgent = void 0;
var _rxjs = require("rxjs");
var _server = require("@kbn/inference-plugin/server");
var _langgraph = require("@langchain/langgraph");
var _from_inference = require("@kbn/inference-langchain/src/chat_model/from_inference");
var _to_inference = require("@kbn/inference-langchain/src/chat_model/to_inference");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNlToEsqlAgent = ({
  connectorId,
  inference,
  logger,
  request,
  tools
}) => {
  return async state => {
    const {
      messages: stateMessages
    } = state;
    const inferenceMessages = (0, _to_inference.messagesToInference)(stateMessages);
    const result = await (0, _rxjs.lastValueFrom)((0, _server.naturalLanguageToEsql)({
      client: inference.getClient({
        request
      }),
      connectorId,
      functionCalling: 'auto',
      logger,
      tools: (0, _to_inference.toolDefinitionToInference)(tools),
      messages: inferenceMessages.messages,
      system: "Just produce the query fenced by the esql tag. Don't explain it."
    }));

    // const aiMessage = requireFirstInspectIndexMappingCallWithEmptyKey(responseToLangchainMessage(result), stateMessages);

    return new _langgraph.Command({
      update: {
        maximumEsqlGenerationAttempts: state.maximumEsqlGenerationAttempts - 1,
        messages: [(0, _from_inference.responseToLangchainMessage)(result)]
      }
    });
  };
};
exports.getNlToEsqlAgent = getNlToEsqlAgent;