"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.leadingActionsColumnStyles = exports.UnifiedTimelineGlobalStyles = exports.StyledUnifiedTableFlexItem = exports.StyledTimelineUnifiedDataTable = exports.StyledTableFlexGroup = exports.StyledPageContentWrapper = exports.StyledMainEuiPanel = exports.StyledEuiProgress = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledTableFlexGroup = exports.StyledTableFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup).attrs(({
  className = ''
}) => ({
  className: `${className}`
}))`
  margin: 0;
  width: 100%;
  overflow: hidden;

  .dscPageBody__contents {
    overflow: hidden;
    height: 100%;
  }
`;
const StyledUnifiedTableFlexItem = exports.StyledUnifiedTableFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem).attrs(({
  className = ''
}) => ({
  className: `${className}`
}))`
  ${({
  theme
}) => `margin: 0 ${theme.eui.euiSizeM};`}
  overflow: hidden;
`;
const StyledEuiProgress = exports.StyledEuiProgress = (0, _styledComponents.default)(_eui.EuiProgress)`
  z-index: 2;
`;
const StyledPageContentWrapper = exports.StyledPageContentWrapper = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  className: `${className}`
}))`
  height: 100%;
  overflow: hidden;
  position: relative;
`;
const StyledMainEuiPanel = exports.StyledMainEuiPanel = (0, _styledComponents.default)(_eui.EuiPanel).attrs(({
  className = ''
}) => ({
  className: `udtPageContent__wrapper ${className}`
}))`
  overflow: hidden; // Ensures horizontal scroll of table
  display: flex;
  flex-direction: column;
  height: 100%;
`;
const leadingActionsColumnStyles = exports.leadingActionsColumnStyles = `
  .udtTimeline .euiDataGridRowCell--controlColumn:nth-child(3) .euiDataGridRowCell__content {
    padding: 0;
  }
`;
const StyledTimelineUnifiedDataTable = exports.StyledTimelineUnifiedDataTable = _styledComponents.default.div.attrs(({
  className = ''
}) => ({
  className: `unifiedDataTable ${className}`,
  role: 'rowgroup'
}))`
  height: 100%;

  .udtTimeline .euiDataGrid__virtualized {
    ${({
  theme
}) => `scrollbar-color: ${theme.eui.euiColorMediumShade} ${theme.eui.euiColorLightShade}`};
  }

  .udtTimeline [data-gridcell-column-id|='select'] {
    border-right: none;
  }

  .udtTimeline [data-gridcell-column-id|='openDetails'] {
    /* custom row height based on number of lines */

    .euiDataGridRowCell__content--lineCountHeight,

      /* auto row height */
    .euiDataGridRowCell__content--autoHeight {
      margin-top: 9px;
    }

    /* single row height */

    .euiDataGridRowCell__content--defaultHeight {
      margin-top: 3px;
    }
  }

  .udtTimeline
    .euiDataGridHeaderCell.euiDataGridHeaderCell--controlColumn:not(
      [data-gridcell-column-id='select']
    ) {
    padding: 0;
    position: relative;
  }

  .udtTimeline .euiDataGridRowCell--controlColumn {
    overflow: visible;
  }

  .udtTimeline [data-gridcell-column-id|='select'] {
    /* custom row height based on number of lines */

    .euiDataGridRowCell__content--lineCountHeight,

      /* auto row height */
    .euiDataGridRowCell__content--autoHeight {
      margin-top: 3px;
    }

    /* single row height */

    .euiDataGridRowCell__content--defaultHeight {
      margin-top: 3px;
    }
  }

  .udtTimeline
    [data-gridcell-column-id|='select']
    .udtTimeline
    .euiDataGridRow:hover
    .euiDataGridRowCell--lastColumn.euiDataGridRowCell--controlColumn {
    ${({
  theme
}) => `background-color: ${theme.eui.colorLightShade};`};
  }

  .udtTimeline .euiDataGridRowCell--lastColumn.euiDataGridRowCell--controlColumn {
    ${({
  theme
}) => `background-color: ${theme.eui.emptyShade};`};
  }

  .udtTimeline .siemEventsTable__trSupplement--summary {
    border-radius: 8px;
  }

  .udtTimeline .euiDataGridRow:has(.buildingBlockType),
  .udtTimeline .euiDataGridRow.buildingBlockType {
    background: repeating-linear-gradient(
      127deg,
      rgba(245, 167, 0, 0.2),
      rgba(245, 167, 0, 0.2) 1px,
      rgba(245, 167, 0, 0.05) 2px,
      rgba(245, 167, 0, 0.05) 10px
    );
  }

  .udtTimeline .euiDataGridRow:has(.eqlSequence),
  .udtTimeline .euiDataGridRow.eqlSequence {
    .euiDataGridRowCell--controlColumn.euiDataGridRowCell--lastColumn,
    .udt--customRow {
      ${({
  theme
}) => `border-left: 4px solid ${theme.eui.euiColorPrimary}`};
    }

    background: repeating-linear-gradient(
      127deg,
      rgba(0, 107, 180, 0.2),
      rgba(0, 107, 180, 0.2) 1px,
      rgba(0, 107, 180, 0.05) 2px,
      rgba(0, 107, 180, 0.05) 10px
    );
  }

  .udtTimeline .euiDataGridRow:has(.eqlNonSequence),
  .udtTimeline .euiDataGridRow.eqlNonSequence {
    .euiDataGridRowCell--controlColumn.euiDataGridRowCell--lastColumn,
    .udt--customRow {
      ${({
  theme
}) => `border-left: 4px solid ${theme.eui.euiColorAccent};`}
    }

    background: repeating-linear-gradient(
      127deg,
      rgba(221, 10, 115, 0.2),
      rgba(221, 10, 115, 0.2) 1px,
      rgba(221, 10, 115, 0.05) 2px,
      rgba(221, 10, 115, 0.05) 10px
    );
  }

  .udtTimeline .euiDataGridRow:has(.nonRawEvent),
  .udtTimeline .euiDataGridRow.nonRawEvent {
    .euiDataGridRowCell--controlColumn.euiDataGridRowCell--lastColumn,
    .udt--customRow {
      ${({
  theme
}) => `border-left: 4px solid ${theme.eui.euiColorWarning};`}
    }
  }

  .udtTimeline .euiDataGridRow:has(.rawEvent),
  .udtTimeline .euiDataGridRow.rawEvent {
    .euiDataGridRowCell--controlColumn.euiDataGridRowCell--lastColumn,
    .udt--customRow {
      ${({
  theme
}) => `border-left: 4px solid ${theme.eui.euiColorLightShade};`}
    }
  }

  .udtTimeline .rowCellWrapper {
    display: flex;
    width: fit-content;
  }

  .udtTimeline .rightPosition {
    position: absolute;
    right: 5px;

    button {
      ${({
  theme
}) => `color: ${theme.eui.euiColorDarkShade};`}
    }
  }

  .udtTimeline .euiDataGrid__rightControls {
    padding-right: 30px;
  }

  .udtTimeline .euiDataGrid__leftControls {
    display: flex;
    align-items: baseline;
  }

  .euiDataGrid__customRenderBody {
    scrollbar-color: transparent !important;
  }

  ${leadingActionsColumnStyles}
`;

// we need this flyout to be above the timeline flyout (which has a z-index of 1003)
const UnifiedTimelineGlobalStyles = exports.UnifiedTimelineGlobalStyles = (0, _styledComponents.createGlobalStyle)`
  body:has(.timeline-portal-overlay-mask) .unifiedDataTable__cellPopover {
    z-index: 1004 !important;
  }
`;