"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimelineRowTypeIndicator = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTimelineRowTypeIndicator = (row, euiTheme) => {
  const isAlert = (0, _discoverUtils.getFieldValue)(row, 'event.kind') === 'signal';
  const isEql = !(0, _lodash.isEmpty)((0, _discoverUtils.getFieldValue)(row, 'eql.parentId')) && !(0, _lodash.isEmpty)((0, _discoverUtils.getFieldValue)(row, 'eql.sequenceNumber'));
  if (isEql) {
    var _ref;
    const sequenceNumber = ((_ref = (0, _discoverUtils.getFieldValue)(row, 'eql.sequenceNumber')) !== null && _ref !== void 0 ? _ref : '').split('-')[0];
    const isEvenSequence = parseInt(sequenceNumber, 10) % 2 === 0;
    return {
      /* alternating colors to differentiate consecutive sequences */
      color: isEvenSequence ? euiTheme.colors.primary : euiTheme.colors.accent,
      label: 'EQL Sequence'
    };
  }
  if (isAlert) {
    return {
      color: euiTheme.colors.warning,
      label: 'Alert'
    };
  }
  return {
    color: euiTheme.colors.lightShade,
    label: 'Event'
  };
};
exports.getTimelineRowTypeIndicator = getTimelineRowTypeIndicator;