"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShouldShowAlertsOnlyMigrationMessage = void 0;
var _react = require("react");
var _constants = require("../../../../../../../common/constants");
var _use_space_id = require("../../../../../../common/hooks/use_space_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Determines whether to show the "alerts only" migration callout based on the current timeline indices and dataview
 */
const useShouldShowAlertsOnlyMigrationMessage = ({
  currentTimelineIndices,
  dataViewId
}) => {
  const currentSpace = (0, _use_space_id.useSpaceId)();
  return (0, _react.useMemo)(() => {
    // The only selected pattern is the alerts index pattern
    const isAlertsOnly = currentTimelineIndices.length === 1 && currentTimelineIndices[0].includes(_constants.DEFAULT_ALERTS_INDEX);

    // The current data view is the default data view for the current space
    const currentDataView = dataViewId === `${_constants.DEFAULT_DATA_VIEW_ID}-${currentSpace}`;

    // Since the default data view is not just the alerts index, we can safely assume this user had
    // "show detection alerts only" enabled and is now impacted by the removal of that feature.
    return isAlertsOnly && currentDataView;
  }, [currentSpace, currentTimelineIndices, dataViewId]);
};
exports.useShouldShowAlertsOnlyMigrationMessage = useShouldShowAlertsOnlyMigrationMessage;