"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CALL_OUT_UNAUTHORIZED_MSG = exports.CALL_OUT_IMMUTABLE = exports.CALL_OUT_FILTER_FOR_ALERTS_BUTTON = exports.CALL_OUT_ALERTS_ONLY_MIGRATION_TITLE = exports.CALL_OUT_ALERTS_ONLY_MIGRATION_SWITCH_BUTTON = exports.CALL_OUT_ALERTS_ONLY_MIGRATION_CONTENT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CALL_OUT_UNAUTHORIZED_MSG = exports.CALL_OUT_UNAUTHORIZED_MSG = _i18n.i18n.translate('xpack.securitySolution.timeline.callOut.unauthorized.message.description', {
  defaultMessage: 'You can use Timeline to investigate events, but you do not have the required permissions to save timelines for future use. If you need to save timelines, contact your Kibana administrator.'
});
const CALL_OUT_IMMUTABLE = exports.CALL_OUT_IMMUTABLE = _i18n.i18n.translate('xpack.securitySolution.timeline.callOut.immutable.message.description', {
  defaultMessage: 'This prebuilt timeline template cannot be modified. To make changes, please duplicate this template and make modifications to the duplicate template.'
});
const CALL_OUT_ALERTS_ONLY_MIGRATION_TITLE = exports.CALL_OUT_ALERTS_ONLY_MIGRATION_TITLE = _i18n.i18n.translate('xpack.securitySolution.timeline.callOut.alertsOnlyMigration.message.title', {
  defaultMessage: 'Show detection alerts option has been removed.'
});
const CALL_OUT_ALERTS_ONLY_MIGRATION_CONTENT = exports.CALL_OUT_ALERTS_ONLY_MIGRATION_CONTENT = _i18n.i18n.translate('xpack.securitySolution.timeline.callOut.alertsOnlyMigration.message.description', {
  defaultMessage: 'Show only alerts by adding a filter or switching to the security alerts data view.'
});
const CALL_OUT_ALERTS_ONLY_MIGRATION_SWITCH_BUTTON = exports.CALL_OUT_ALERTS_ONLY_MIGRATION_SWITCH_BUTTON = _i18n.i18n.translate('xpack.securitySolution.timeline.callOut.alertsOnlyMigration.switchButton.label', {
  defaultMessage: 'Switch to alerts data view.'
});
const CALL_OUT_FILTER_FOR_ALERTS_BUTTON = exports.CALL_OUT_FILTER_FOR_ALERTS_BUTTON = _i18n.i18n.translate('xpack.securitySolution.timeline.callOut.alertsOnlyMigration.message.filterForAlerts', {
  defaultMessage: 'Filter for alerts.'
});