"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.zeekRowRenderer = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _timeline = require("../../../../../../../common/api/timeline");
var _row_renderer = require("../row_renderer");
var _zeek_details = require("./zeek_details");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/zeek/zeek_row_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const zeekRowRenderer = exports.zeekRowRenderer = {
  id: _timeline.RowRendererIdEnum.zeek,
  isInstance: ecs => {
    const module = (0, _fp.get)('event.module[0]', ecs);
    return module != null && module.toLowerCase() === 'zeek';
  },
  renderRow: ({
    data,
    scopeId
  }) => /*#__PURE__*/_react.default.createElement(_row_renderer.RowRendererContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_zeek_details.ZeekDetails, {
    data: data,
    timelineId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 7
    }
  }))
};