"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatefulRowRenderer = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/timelines-plugin/public");
var _use_stateful_event_focus = require("../use_stateful_event_focus");
var i18n = _interopRequireWildcard(require("../translations"));
var _use_stateful_row_renderer = require("./use_stateful_row_renderer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/events/stateful_row_renderer/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * This component addresses the accessibility of row renderers.
 *
 * accessibility details:
 * - This component has a 'dialog' `role` because it's rendered as a dialog
 *   "outside" the current row for screen readers, similar to a popover
 * - It has tabIndex="0" to allow for keyboard focus
 * - It traps keyboard focus when a user clicks inside a row renderer, to
 *   allow for tabbing through the contents of row renderers
 * - The "dialog" can be dismissed via the up arrow key, down arrow key,
 *   which focuses the current or next row, respectively.
 * - A screen-reader-only message provides additional context and instruction
 */
const StatefulRowRenderer = exports.StatefulRowRenderer = /*#__PURE__*/_react.default.memo(({
  ariaRowindex,
  containerRef,
  event,
  lastFocusedAriaColindex,
  rowRenderers,
  timelineId
}) => {
  const {
    focusOwnership,
    onFocus,
    onKeyDown,
    onOutsideClick
  } = (0, _use_stateful_event_focus.useStatefulEventFocus)({
    ariaRowindex,
    colindexAttribute: _public.ARIA_COLINDEX_ATTRIBUTE,
    containerRef,
    lastFocusedAriaColindex,
    onColumnFocused: _fp.noop,
    rowindexAttribute: _public.ARIA_ROWINDEX_ATTRIBUTE
  });
  const {
    rowRenderer
  } = (0, _use_stateful_row_renderer.useStatefulRowRenderer)({
    data: event.ecs,
    rowRenderers
  });
  const row = (0, _react.useMemo)(() => {
    const result = rowRenderer === null || rowRenderer === void 0 ? void 0 : rowRenderer.renderRow({
      data: event.ecs,
      scopeId: timelineId
    });
    return result;
  }, [rowRenderer, event.ecs, timelineId]);
  const content = (0, _react.useMemo)(() => rowRenderer &&
  /*#__PURE__*/
  // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
  _react.default.createElement("div", {
    className: (0, _public.getRowRendererClassName)(ariaRowindex),
    role: "dialog",
    onFocus: onFocus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: onOutsideClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    clickOutsideDisables: true,
    disabled: focusOwnership !== 'owned',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    "data-test-subj": "eventRendererScreenReaderOnly",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 19
    }
  }, i18n.YOU_ARE_IN_AN_EVENT_RENDERER(ariaRowindex))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    onKeyDown: onKeyDown,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 19
    }
  }, row))))), [ariaRowindex, focusOwnership, onFocus, onKeyDown, onOutsideClick, rowRenderer, row]);
  return content;
});
StatefulRowRenderer.displayName = 'StatefulRowRenderer';