"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCommonColumns = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _common_styles = require("./common_styles");
var _helpers = require("../helpers");
var _note_previews = require("../note_previews");
var i18n = _interopRequireWildcard(require("../translations"));
var _empty_value = require("../../../../common/components/empty_value");
var _formatted_date = require("../../../../common/components/formatted_date");
var _timeline = require("../../../../../common/api/timeline");
var _types = require("../../../../../common/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/open_timeline/timelines_table/common_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LineClampTextContainer = _styledComponents.default.span`
  text-overflow: ellipsis;
  display: -webkit-box;
  -webkit-line-clamp: 5;
  -webkit-box-orient: vertical;
  overflow: hidden;
`;

/**
 * Returns the column definitions (passed as the `columns` prop to
 * `EuiBasicTable`) that are common to the compact `Open Timeline` modal view,
 * and the full view shown in the `All Timelines` view of the `Timelines` page
 */
const getCommonColumns = ({
  itemIdToExpandedNotesRowMap,
  onOpenTimeline,
  onToggleShowNotes,
  timelineType
}) => [{
  dataType: 'auto',
  isExpander: true,
  render: ({
    notes,
    savedObjectId
  }) => notes != null && notes.length > 0 && savedObjectId != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "expand-notes",
    onClick: () => itemIdToExpandedNotesRowMap[savedObjectId] != null ? onToggleShowNotes((0, _fp.omit)(savedObjectId, itemIdToExpandedNotesRowMap)) : onToggleShowNotes({
      ...itemIdToExpandedNotesRowMap,
      [savedObjectId]: /*#__PURE__*/_react.default.createElement(_note_previews.NotePreviews, {
        notes: notes,
        timelineId: _types.TimelineId.active,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 36
        }
      })
    }),
    "aria-label": itemIdToExpandedNotesRowMap[savedObjectId] ? i18n.COLLAPSE : i18n.EXPAND,
    iconType: itemIdToExpandedNotesRowMap[savedObjectId] ? 'arrowDown' : 'arrowRight',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }) : null,
  width: _common_styles.ACTION_COLUMN_WIDTH
}, {
  dataType: 'string',
  field: 'title',
  name: timelineType === _timeline.TimelineTypeEnum.default ? i18n.TIMELINE_NAME : i18n.TIMELINE_TEMPLATE_NAME,
  render: (title, timelineResult) => timelineResult.savedObjectId != null ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `timeline-title-${timelineResult.savedObjectId}`,
    onClick: () => onOpenTimeline({
      duplicate: false,
      timelineId: `${timelineResult.savedObjectId}`
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, (0, _helpers.isUntitled)(timelineResult) ? i18n.UNTITLED_TIMELINE : /*#__PURE__*/_react.default.createElement(LineClampTextContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }, title)) : /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `title-no-saved-object-id-${title || 'no-title'}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, (0, _helpers.isUntitled)(timelineResult) ? i18n.UNTITLED_TIMELINE : title),
  sortable: false
}, {
  dataType: 'string',
  field: 'description',
  name: i18n.DESCRIPTION,
  render: description => /*#__PURE__*/_react.default.createElement(LineClampTextContainer, {
    "data-test-subj": "description",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, description != null && description.trim().length > 0 ? description : (0, _empty_value.getEmptyTagValue)()),
  sortable: false
}, {
  dataType: 'date',
  field: 'updated',
  name: i18n.LAST_MODIFIED,
  render: (date, timelineResult) => /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "updated",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, timelineResult.updated != null ? /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
    value: date,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }) : (0, _empty_value.getEmptyTagValue)()),
  sortable: true
}];
exports.getCommonColumns = getCommonColumns;