"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ParticipantsComponent = exports.OldNotes = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _store = require("../../store");
var _use_selector = require("../../../common/hooks/use_selector");
var _timeline = require("../../../../common/api/timeline");
var _app = require("../../../common/store/app");
var _add_note = require("./add_note");
var _translations = require("./translations");
var _translations2 = require("../timeline/translations");
var _note_previews = require("../open_timeline/note_previews");
var _selectors = require("../timeline/tabs/notes/selectors");
var _selectors2 = require("../timeline/tabs/selectors");
var _scroll_to_top = require("../../../common/components/scroll_to_top");
var _user_privileges = require("../../../common/components/user_privileges");
var _layout = require("../timeline/tabs/shared/layout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/notes/old_notes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ScrollableDiv = _styledComponents.default.div`
  overflow-x: hidden;
  overflow-y: auto;
  padding-inline: ${({
  theme
}) => theme.eui.euiSizeM};
  padding-block: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const StyledEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  flex: 0;
`;
const Username = (0, _styledComponents.default)(_eui.EuiText)`
  font-weight: bold;
`;
const UsernameWithAvatarComponent = ({
  username
}) => /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
  gutterSize: "s",
  responsive: false,
  alignItems: "center",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 59,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 60,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
  "data-test-subj": "avatar",
  name: username,
  size: "l",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 61,
    columnNumber: 7
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 63,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(Username, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 64,
    columnNumber: 7
  }
}, username)));
const UsernameWithAvatar = /*#__PURE__*/_react.default.memo(UsernameWithAvatarComponent);
const ParticipantsComponent = ({
  users
}) => {
  const List = (0, _react.useMemo)(() => users.map(user => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: user.updatedBy === null ? undefined : user.updatedBy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(UsernameWithAvatar, {
    key: user.updatedBy === null ? undefined : user.updatedBy,
    username: String(user.updatedBy),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }))), [users]);
  if (!users.length) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, _translations2.PARTICIPANTS)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }), List);
};
exports.ParticipantsComponent = ParticipantsComponent;
ParticipantsComponent.displayName = 'ParticipantsComponent';
const Participants = /*#__PURE__*/_react.default.memo(ParticipantsComponent);
/**
 * Renders the "old" notes tab content. This should be removed when we remove the securitySolutionNotesDisabled feature flag
 */
const OldNotes = exports.OldNotes = /*#__PURE__*/_react.default.memo(({
  timelineId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    notesPrivileges
  } = (0, _user_privileges.useUserPrivileges)();
  const getScrollToTop = (0, _react.useMemo)(() => (0, _selectors2.getScrollToTopSelector)(), []);
  const scrollToTop = (0, _use_selector.useShallowEqualSelector)(state => getScrollToTop(state, timelineId));
  (0, _scroll_to_top.useScrollToTop)('#scrollableNotes', !!scrollToTop);
  const getTimelineNotes = (0, _react.useMemo)(() => (0, _selectors.getTimelineNoteSelector)(), []);
  const {
    createdBy,
    eventIdToNoteIds,
    noteIds,
    status: timelineStatus
  } = (0, _use_selector.useDeepEqualSelector)(state => getTimelineNotes(state, timelineId));
  const getNotesAsCommentsList = (0, _react.useMemo)(() => _app.appSelectors.selectNotesAsCommentsListSelector(), []);
  const [newNote, setNewNote] = (0, _react.useState)('');
  const isImmutable = timelineStatus === _timeline.TimelineStatusEnum.immutable;
  const appNotes = (0, _use_selector.useDeepEqualSelector)(getNotesAsCommentsList);
  const allTimelineNoteIds = (0, _react.useMemo)(() => {
    const eventNoteIds = Object.values(eventIdToNoteIds).reduce((acc, v) => [...acc, ...v], []);
    return [...noteIds, ...eventNoteIds];
  }, [noteIds, eventIdToNoteIds]);
  const notes = (0, _react.useMemo)(() => appNotes.filter(appNote => {
    var _appNote$noteId;
    return allTimelineNoteIds.includes((_appNote$noteId = appNote === null || appNote === void 0 ? void 0 : appNote.noteId) !== null && _appNote$noteId !== void 0 ? _appNote$noteId : '-1');
  }), [appNotes, allTimelineNoteIds]);

  // filter for savedObjectId to make sure we don't display `elastic` user while saving the note
  const participants = (0, _react.useMemo)(() => (0, _fp.uniqBy)('updatedBy', (0, _fp.filter)('savedObjectId', notes)), [notes]);
  const associateNote = (0, _react.useCallback)(noteId => dispatch(_store.timelineActions.addNote({
    id: timelineId,
    noteId
  })), [dispatch, timelineId]);
  const SidebarContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, createdBy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 15
    }
  }, _translations.CREATED_BY)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(UsernameWithAvatar, {
    username: createdBy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(Participants, {
    users: participants,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 9
    }
  })), [createdBy, participants]);
  return /*#__PURE__*/_react.default.createElement(_layout.FullWidthFlexGroup, {
    gutterSize: "none",
    "data-test-subj": 'old-notes-screen',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: ScrollableDiv,
    grow: 2,
    id: "scrollableNotes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_note_previews.NotePreviews, {
    notes: notes,
    timelineId: timelineId,
    showTimelineDescription: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }), !isImmutable && notesPrivileges.crud === true && /*#__PURE__*/_react.default.createElement(_add_note.AddNote, {
    associateNote: associateNote,
    newNote: newNote,
    updateNewNote: setNewNote,
    autoFocusDisabled: !!scrollToTop,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_layout.VerticalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: ScrollableDiv,
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 7
    }
  }, SidebarContent));
});
OldNotes.displayName = 'OldNotes';