"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetflowColumns = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _source_destination = require("../../../../explore/network/components/source_destination");
var _duration_event_start_end = require("./duration_event_start_end");
var _user_process = require("./user_process");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/netflow/netflow_columns/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EuiFlexItemMarginRight = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-right: 10px;
`;
EuiFlexItemMarginRight.displayName = 'EuiFlexItemMarginRight';

/**
 * Renders columns of draggable badges that describe both Netflow data, or more
 * generally, hosts interacting over a network connection. This component is
 * consumed by the `Netflow` visualization / row renderer.
 *
 * This component will allow columns to wrap if constraints on width prevent all
 * the columns from fitting on a single horizontal row
 */
const NetflowColumns = exports.NetflowColumns = /*#__PURE__*/_react.default.memo(({
  contextId,
  scopeId,
  destinationBytes,
  destinationGeoContinentName,
  destinationGeoCountryName,
  destinationGeoCountryIsoCode,
  destinationGeoRegionName,
  destinationGeoCityName,
  destinationIp,
  destinationPackets,
  destinationPort,
  eventDuration,
  eventId,
  eventEnd,
  eventStart,
  networkBytes,
  networkCommunityId,
  networkDirection,
  networkPackets,
  networkProtocol,
  processName,
  sourceBytes,
  sourceGeoContinentName,
  sourceGeoCountryName,
  sourceGeoCountryIsoCode,
  sourceGeoRegionName,
  sourceGeoCityName,
  sourceIp,
  sourcePackets,
  sourcePort,
  transport,
  userName
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  "data-test-subj": "netflow-columns",
  gutterSize: "none",
  justifyContent: "center",
  wrap: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 67,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(EuiFlexItemMarginRight, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 73,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_user_process.UserProcess, {
  scopeId: scopeId,
  contextId: contextId,
  eventId: eventId,
  processName: processName,
  userName: userName,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 74,
    columnNumber: 9
  }
})), /*#__PURE__*/_react.default.createElement(EuiFlexItemMarginRight, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 83,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_duration_event_start_end.DurationEventStartEnd, {
  scopeId: scopeId,
  contextId: contextId,
  eventDuration: eventDuration,
  eventId: eventId,
  eventEnd: eventEnd,
  eventStart: eventStart,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 84,
    columnNumber: 9
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 94,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_source_destination.SourceDestination, {
  scopeId: scopeId,
  contextId: contextId,
  destinationBytes: destinationBytes,
  destinationGeoContinentName: destinationGeoContinentName,
  destinationGeoCountryName: destinationGeoCountryName,
  destinationGeoCountryIsoCode: destinationGeoCountryIsoCode,
  destinationGeoRegionName: destinationGeoRegionName,
  destinationGeoCityName: destinationGeoCityName,
  destinationIp: destinationIp,
  destinationPackets: destinationPackets,
  destinationPort: destinationPort,
  eventId: eventId,
  networkBytes: networkBytes,
  networkCommunityId: networkCommunityId,
  networkDirection: networkDirection,
  networkPackets: networkPackets,
  networkProtocol: networkProtocol,
  sourceBytes: sourceBytes,
  sourceGeoContinentName: sourceGeoContinentName,
  sourceGeoCountryName: sourceGeoCountryName,
  sourceGeoCountryIsoCode: sourceGeoCountryIsoCode,
  sourceGeoRegionName: sourceGeoRegionName,
  sourceGeoCityName: sourceGeoCityName,
  sourceIp: sourceIp,
  sourcePackets: sourcePackets,
  sourcePort: sourcePort,
  transport: transport,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 95,
    columnNumber: 9
  }
}))));
NetflowColumns.displayName = 'NetflowColumns';