"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Netflow = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _fingerprints = require("./fingerprints");
var _netflow_columns = require("./netflow_columns");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/netflow/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Renders a visual representation of network traffic between hosts,
 * typically for use in a row renderer. In addition to rendering Netflow event
 * data (i.e. `event.action: netflow_flow`), this row renderer is also useful
 * when, for example:
 * - `event.action` is `network_flow` or `socket_open`
 * - `event.category` is `network_traffic`
 * - rendering data from `Zeek` and `Suricata`
 */
const Netflow = exports.Netflow = /*#__PURE__*/_react.default.memo(({
  contextId,
  scopeId,
  destinationBytes,
  destinationGeoContinentName,
  destinationGeoCountryName,
  destinationGeoCountryIsoCode,
  destinationGeoRegionName,
  destinationGeoCityName,
  destinationIp,
  destinationPackets,
  destinationPort,
  eventDuration,
  eventId,
  eventEnd,
  eventStart,
  networkBytes,
  networkCommunityId,
  networkDirection,
  networkPackets,
  networkProtocol,
  processName,
  sourceBytes,
  sourceGeoContinentName,
  sourceGeoCountryName,
  sourceGeoCountryIsoCode,
  sourceGeoRegionName,
  sourceGeoCityName,
  sourcePackets,
  sourceIp,
  sourcePort,
  tlsClientCertificateFingerprintSha1,
  tlsFingerprintsJa3Hash,
  tlsServerCertificateFingerprintSha1,
  transport,
  userName
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  "data-test-subj": "netflow-rows",
  direction: "column",
  justifyContent: "center",
  wrap: true,
  gutterSize: "none",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 62,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 70,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_netflow_columns.NetflowColumns, {
  scopeId: scopeId,
  contextId: contextId,
  destinationBytes: destinationBytes,
  destinationGeoContinentName: destinationGeoContinentName,
  destinationGeoCountryName: destinationGeoCountryName,
  destinationGeoCountryIsoCode: destinationGeoCountryIsoCode,
  destinationGeoRegionName: destinationGeoRegionName,
  destinationGeoCityName: destinationGeoCityName,
  destinationIp: destinationIp,
  destinationPackets: destinationPackets,
  destinationPort: destinationPort,
  eventDuration: eventDuration,
  eventId: eventId,
  eventEnd: eventEnd,
  eventStart: eventStart,
  networkBytes: networkBytes,
  networkCommunityId: networkCommunityId,
  networkDirection: networkDirection,
  networkPackets: networkPackets,
  networkProtocol: networkProtocol,
  processName: processName,
  sourceBytes: sourceBytes,
  sourceGeoContinentName: sourceGeoContinentName,
  sourceGeoCountryName: sourceGeoCountryName,
  sourceGeoCountryIsoCode: sourceGeoCountryIsoCode,
  sourceGeoRegionName: sourceGeoRegionName,
  sourceGeoCityName: sourceGeoCityName,
  sourceIp: sourceIp,
  sourcePackets: sourcePackets,
  sourcePort: sourcePort,
  transport: transport,
  userName: userName,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 71,
    columnNumber: 9
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 106,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_fingerprints.Fingerprints, {
  scopeId: scopeId,
  contextId: contextId,
  eventId: eventId,
  tlsClientCertificateFingerprintSha1: tlsClientCertificateFingerprintSha1,
  tlsFingerprintsJa3Hash: tlsFingerprintsJa3Hash,
  tlsServerCertificateFingerprintSha1: tlsServerCertificateFingerprintSha1,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 107,
    columnNumber: 9
  }
}))));
Netflow.displayName = 'Netflow';