"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePaneStyles = exports.OverflowHiddenGlobalStyles = void 0;
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/modal/index.styles.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const usePaneStyles = () => {
  const EuiTheme = (0, _eui.useEuiTheme)();
  const {
    euiTheme
  } = EuiTheme;
  return (0, _css.css)`
    // euiOverlayMask styles
    position: fixed;
    top: var(--kbn-layout--application-top, 0px);
    left: var(--kbn-layout--application-left, 0px);
    right: var(--kbn-layout--application-right, 0px);
    bottom: var(--kbn-layout--application-bottom, 0px);
    // TODO EUI: add color with transparency
    background: ${(0, _eui.transparentize)(euiTheme.colors.ink, 0.5)};
    z-index: ${euiTheme.levels.flyout + 2}; // this z-index needs to be between the documentFlyout (set at 1001) and the timelineFlyout (set at 1003)

    ${_eui.euiCanAnimate} {
      animation: ${_eui.euiAnimFadeIn} ${euiTheme.animation.fast} ease-in;
    }

    &.timeline-portal-overlay-mask--hidden {
      display: none;
    }

    .timeline-container {
      min-width: 150px;
      position: fixed;
      top: var(--kbn-layout--application-top, 0px);
      left: var(--kbn-layout--application-left, 0px);
      right: var(--kbn-layout--application-right, 0px);
      bottom: var(--kbn-layout--application-bottom, 0px);
      background: ${(0, _eui.euiBackgroundColor)(EuiTheme, 'plain')};
      ${_eui.euiCanAnimate} {
        animation: ${(0, _eui.euiAnimSlideInUp)(euiTheme.size.xxl)} ${euiTheme.animation.normal}
          cubic-bezier(0.39, 0.575, 0.565, 1);
      }
    }

    &:not(.timeline-portal-overlay-mask--full-screen) .timeline-container {
      margin: ${euiTheme.size.m};
      border-radius: ${euiTheme.border.radius.medium};
    }
  `;
};
exports.usePaneStyles = usePaneStyles;
const OverflowHiddenGlobalStyles = () => {
  return /*#__PURE__*/_react.default.createElement(_react2.Global, {
    styles: 'body { overflow: hidden }',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 10
    }
  });
};
exports.OverflowHiddenGlobalStyles = OverflowHiddenGlobalStyles;