"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RUNTIME_FIELD = exports.RUNTIME = exports.REMOVE_DESCRIPTION = exports.REMOVE = exports.NAME = exports.EDIT_DESCRIPTION = exports.EDIT = exports.DESCRIPTION_FOR_FIELD = exports.DESCRIPTION = exports.CATEGORY = exports.ACTIONS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NAME = exports.NAME = _i18n.i18n.translate('xpack.securitySolution.fieldBrowser.fieldName', {
  defaultMessage: 'Name'
});
const DESCRIPTION = exports.DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.fieldBrowser.descriptionLabel', {
  defaultMessage: 'Description'
});
const DESCRIPTION_FOR_FIELD = field => _i18n.i18n.translate('xpack.securitySolution.fieldBrowser.descriptionForScreenReaderOnly', {
  values: {
    field
  },
  defaultMessage: 'Description for field {field}:'
});
exports.DESCRIPTION_FOR_FIELD = DESCRIPTION_FOR_FIELD;
const CATEGORY = exports.CATEGORY = _i18n.i18n.translate('xpack.securitySolution.fieldBrowser.categoryLabel', {
  defaultMessage: 'Category'
});
const RUNTIME = exports.RUNTIME = _i18n.i18n.translate('xpack.securitySolution.fieldBrowser.runtimeLabel', {
  defaultMessage: 'Runtime'
});
const RUNTIME_FIELD = exports.RUNTIME_FIELD = _i18n.i18n.translate('xpack.securitySolution.fieldBrowser.runtimeTitle', {
  defaultMessage: 'Runtime Field'
});
const ACTIONS = exports.ACTIONS = _i18n.i18n.translate('xpack.securitySolution.fieldBrowser.actionsLabel', {
  defaultMessage: 'Actions'
});
const EDIT = exports.EDIT = _i18n.i18n.translate('xpack.securitySolution.fieldBrowser.editButton', {
  defaultMessage: 'Edit'
});
const REMOVE = exports.REMOVE = _i18n.i18n.translate('xpack.securitySolution.fieldBrowser.removeButton', {
  defaultMessage: 'Remove'
});
const EDIT_DESCRIPTION = exports.EDIT_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.fieldBrowser.editButtonDescription', {
  defaultMessage: 'Edit runtime field'
});
const REMOVE_DESCRIPTION = exports.REMOVE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.fieldBrowser.removeButtonDescription', {
  defaultMessage: 'Delete runtime field'
});