"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInitialOperatorLabel = exports.StatefulEditDataProvider = exports.HeaderContainer = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _timeline = require("../../../../common/api/timeline");
var _helpers = require("./helpers");
var _components = require("./components");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/edit_data_provider/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EDIT_DATA_PROVIDER_WIDTH = 400;
const OPERATOR_COMBO_BOX_WIDTH = 152;
const SAVE_CLASS_NAME = 'edit-data-provider-save';
const VALUE_INPUT_CLASS_NAME = 'edit-data-provider-value';
const HeaderContainer = exports.HeaderContainer = _styledComponents.default.div`
  width: ${EDIT_DATA_PROVIDER_WIDTH};
`;
HeaderContainer.displayName = 'HeaderContainer';
const getInitialOperatorLabel = (isExcluded, operator) => {
  if (operator === ':') {
    return isExcluded ? [{
      label: i18n.IS_NOT
    }] : [{
      label: i18n.IS
    }];
  } else if (operator === 'includes') {
    return isExcluded ? [{
      label: i18n.IS_NOT_ONE_OF
    }] : [{
      label: i18n.IS_ONE_OF
    }];
  } else {
    return isExcluded ? [{
      label: i18n.DOES_NOT_EXIST
    }] : [{
      label: i18n.EXISTS
    }];
  }
};
exports.getInitialOperatorLabel = getInitialOperatorLabel;
const StatefulEditDataProvider = exports.StatefulEditDataProvider = /*#__PURE__*/_react.default.memo(({
  andProviderId,
  browserFields,
  field,
  isExcluded,
  onDataProviderEdited,
  operator,
  providerId,
  timelineId,
  value,
  type = _timeline.DataProviderTypeEnum.default
}) => {
  const [updatedField, setUpdatedField] = (0, _react.useState)([{
    label: field
  }]);
  const [updatedOperator, setUpdatedOperator] = (0, _react.useState)(getInitialOperatorLabel(isExcluded, operator));
  const [updatedValue, setUpdatedValue] = (0, _react.useState)(value);
  const showComboBoxInput = (0, _react.useMemo)(() => updatedOperator.length > 0 && (updatedOperator[0].label === i18n.IS_ONE_OF || updatedOperator[0].label === i18n.IS_NOT_ONE_OF), [updatedOperator]);
  const showValueInput = (0, _react.useMemo)(() => type !== _timeline.DataProviderTypeEnum.template && updatedOperator.length > 0 && updatedOperator[0].label !== i18n.EXISTS && updatedOperator[0].label !== i18n.DOES_NOT_EXIST && !showComboBoxInput, [showComboBoxInput, type, updatedOperator]);
  const disableSave = (0, _react.useMemo)(() => showComboBoxInput && Array.isArray(updatedValue) && !updatedValue.length, [showComboBoxInput, updatedValue]);

  /** Focuses the Value input if it is visible, falling back to the Save button if it's not */
  const focusInput = () => {
    const elements = document.getElementsByClassName(VALUE_INPUT_CLASS_NAME);
    if (elements.length > 0) {
      elements[0].focus(); // this cast is required because focus() does not exist on every `Element` returned by `getElementsByClassName`
    } else {
      const saveElements = document.getElementsByClassName(SAVE_CLASS_NAME);
      if (saveElements.length > 0) {
        saveElements[0].focus();
      }
    }
  };
  const onFieldSelected = (0, _react.useCallback)(selectedField => {
    setUpdatedField(selectedField);
    if (type === _timeline.DataProviderTypeEnum.template) {
      setUpdatedValue(`{${selectedField[0].label}}`);
    }
    focusInput();
  }, [type]);
  const onOperatorSelected = (0, _react.useCallback)(operatorSelected => {
    setUpdatedOperator(operatorSelected);
    focusInput();
  }, []);
  const onValueChange = (0, _react.useCallback)(changedValue => {
    setUpdatedValue(changedValue);
  }, []);
  const disableScrolling = () => {
    const x = window.pageXOffset !== undefined ? window.pageXOffset : (document.documentElement || document.body.parentNode || document.body).scrollLeft;
    const y = window.pageYOffset !== undefined ? window.pageYOffset : (document.documentElement || document.body.parentNode || document.body).scrollTop;
    window.onscroll = () => window.scrollTo(x, y);
  };
  const enableScrolling = () => {
    window.onscroll = () => _fp.noop;
  };
  const handleSave = (0, _react.useCallback)(() => {
    onDataProviderEdited({
      andProviderId,
      excluded: (0, _helpers.getExcludedFromSelection)(updatedOperator),
      field: updatedField.length > 0 ? updatedField[0].label : '',
      id: timelineId,
      operator: (0, _helpers.getQueryOperatorFromSelection)(updatedOperator),
      providerId,
      value: updatedValue,
      type
    });
  }, [onDataProviderEdited, andProviderId, updatedOperator, updatedField, timelineId, providerId, updatedValue, type]);
  (0, _react.useEffect)(() => {
    disableScrolling();
    return () => {
      enableScrolling();
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.FIELD,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    autoFocus: true,
    "data-test-subj": "field",
    isClearable: false,
    onChange: onFieldSelected,
    options: (0, _helpers.getCategorizedFieldNames)(browserFields),
    placeholder: i18n.FIELD_PLACEHOLDER,
    selectedOptions: updatedField,
    singleSelection: {
      asPlainText: true
    },
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "row",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.OPERATOR,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "operator",
    isClearable: false,
    onChange: onOperatorSelected,
    options: _helpers.operatorLabels,
    placeholder: i18n.SELECT_AN_OPERATOR,
    selectedOptions: updatedOperator,
    singleSelection: {
      asPlainText: true
    },
    css: {
      minWidth: OPERATOR_COMBO_BOX_WIDTH
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 11
    }
  }, showValueInput && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.VALUE_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_components.ControlledDefaultInput, {
    onChangeCallback: onValueChange,
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 17
    }
  })), showComboBoxInput && type !== _timeline.DataProviderTypeEnum.template && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.VALUE_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_components.ControlledComboboxInput, {
    onChangeCallback: onValueChange,
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 11
    }
  }, type === _timeline.DataProviderTypeEnum.template && showComboBoxInput && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    size: "s",
    title: i18n.UNAVAILABLE_OPERATOR(updatedOperator[0].label),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    className: SAVE_CLASS_NAME,
    color: "primary",
    "data-test-subj": "save",
    fill: true,
    isDisabled: !(0, _helpers.selectionsAreValid)({
      type,
      browserFields,
      selectedField: updatedField,
      selectedOperator: updatedOperator
    }) || disableSave,
    onClick: handleSave,
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 17
    }
  }, i18n.SAVE))))));
});
StatefulEditDataProvider.displayName = 'StatefulEditDataProvider';