"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterOutContextMenu = exports.FilterOutCellAction = exports.FilterOutButtonIcon = exports.FilterOutButtonEmpty = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_filter_in_out = require("../hooks/use_filter_in_out");
var _filter = require("../utils/filter");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/query_bar/components/filter_out.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ICON_TYPE = 'minusInCircle';
/**
 * Retrieves the indicator's field and value, then creates a new {@link Filter} and adds it to the {@link FilterManager}.
 *
 * This component renders an {@link EuiButtonIcon}.
 *
 * @returns filter out button icon
 */
const FilterOutButtonIcon = ({
  data,
  field,
  'data-test-subj': dataTestSub
}) => {
  const {
    filterFn
  } = (0, _use_filter_in_out.useFilterInOut)({
    indicator: data,
    field,
    filterType: _filter.FilterOut
  });
  if (!filterFn) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.FILTER_OUT_TITLE,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _translations.FILTER_OUT_TITLE,
    iconType: ICON_TYPE,
    iconSize: "s",
    size: "xs",
    color: "primary",
    onClick: filterFn,
    "data-test-subj": dataTestSub,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }));
};

/**
 * Retrieves the indicator's field and value, then creates a new {@link Filter} and adds it to the {@link FilterManager}.
 *
 * This component renders an {@link EuiButtonEmpty}.
 *
 * @returns filter out button empty
 */
exports.FilterOutButtonIcon = FilterOutButtonIcon;
const FilterOutButtonEmpty = ({
  data,
  field,
  'data-test-subj': dataTestSub
}) => {
  const {
    filterFn
  } = (0, _use_filter_in_out.useFilterInOut)({
    indicator: data,
    field,
    filterType: _filter.FilterOut
  });
  if (!filterFn) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.FILTER_OUT_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _translations.FILTER_OUT_TITLE,
    iconType: ICON_TYPE,
    iconSize: "s",
    color: "primary",
    onClick: filterFn,
    "data-test-subj": dataTestSub,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, _translations.FILTER_OUT_TITLE));
};

/**
 * Retrieves the indicator's field and value, then creates a new {@link Filter} and adds it to the {@link FilterManager}.
 *
 * This component is to be used in an EuiContextMenu.
 *
 * @returns filter in {@link EuiContextMenuItem} for a context menu
 */
exports.FilterOutButtonEmpty = FilterOutButtonEmpty;
const FilterOutContextMenu = ({
  data,
  field,
  onAnnounce,
  'data-test-subj': dataTestSub
}) => {
  const {
    filterFn
  } = (0, _use_filter_in_out.useFilterInOut)({
    indicator: data,
    field,
    filterType: _filter.FilterOut
  });
  if (!filterFn) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "filterOut",
    icon: "minusInCircle",
    size: "s",
    onClick: () => {
      filterFn();
      onAnnounce((0, _translations.FILTER_OUT_ANNOUNCEMENT)(field, typeof data === 'string' ? data : ''));
    },
    "data-test-subj": dataTestSub,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 5
    }
  }, _translations.FILTER_OUT_TITLE);
};

/**
 * Retrieves the indicator's field and value, then creates a new {@link Filter} and adds it to the {@link FilterManager}.
 *
 * This component is to be used in an EuiDataGrid.
 *
 * @returns filter in button for data grid
 */
exports.FilterOutContextMenu = FilterOutContextMenu;
const FilterOutCellAction = ({
  data,
  field,
  Component,
  'data-test-subj': dataTestSub
}) => {
  const {
    filterFn
  } = (0, _use_filter_in_out.useFilterInOut)({
    indicator: data,
    field,
    filterType: _filter.FilterOut
  });
  if (!filterFn) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.FILTER_OUT_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": dataTestSub,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(Component, {
    "aria-label": _translations.FILTER_OUT_TITLE,
    iconType: ICON_TYPE,
    onClick: filterFn,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 9
    }
  }, _translations.FILTER_OUT_TITLE)));
};
exports.FilterOutCellAction = FilterOutCellAction;