"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTIDataView = void 0;
var _react = require("react");
var _use_selected_patterns = require("../../../../data_view_manager/hooks/use_selected_patterns");
var _use_browser_fields = require("../../../../data_view_manager/hooks/use_browser_fields");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _containers = require("../../../../sourcerer/containers");
var _indicator = require("../../../../../common/threat_intelligence/types/indicator");
var _translations = require("./translations");
var _use_data_view = require("../../../../data_view_manager/hooks/use_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Inline definition for a runtime field "threat.indicator.name" we are adding for indicators grid
 */
const indicatorNameField = {
  aggregatable: true,
  name: _indicator.RawIndicatorFieldId.Name,
  searchable: true,
  type: 'string',
  category: 'threat',
  description: _translations.DESCRIPTION,
  esTypes: ['keyword']
};
const useTIDataView = () => {
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const oldDataView = (0, _containers.useSourcererDataView)();
  const {
    dataView,
    status
  } = (0, _use_data_view.useDataView)();
  const experimentalBrowserFields = (0, _use_browser_fields.useBrowserFields)();
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)();
  const browserFields = (0, _react.useMemo)(() => {
    const {
      threat = {
        fields: {}
      }
    } = newDataViewPickerEnabled ? experimentalBrowserFields : oldDataView.browserFields;
    return {
      ...(newDataViewPickerEnabled ? experimentalBrowserFields : oldDataView.browserFields),
      threat: {
        fields: {
          ...threat.fields,
          [indicatorNameField.name]: indicatorNameField
        }
      }
    };
  }, [experimentalBrowserFields, newDataViewPickerEnabled, oldDataView.browserFields]);
  return (0, _react.useMemo)(() => ({
    ...(newDataViewPickerEnabled ? {
      sourcererDataView: {
        fields: dataView.fields.toSpec(),
        title: dataView.title,
        id: dataView.id
      },
      loading: status !== 'ready',
      dataViewId: dataView.id,
      indicesExist: dataView.hasMatchedIndices()
    } : oldDataView),
    browserFields,
    selectedPatterns: newDataViewPickerEnabled ? experimentalSelectedPatterns : oldDataView.selectedPatterns
  }), [browserFields, dataView, experimentalSelectedPatterns, newDataViewPickerEnabled, oldDataView, status]);
};
exports.useTIDataView = useTIDataView;