"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenIndicatorFlyoutButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _test_ids = require("./test_ids");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/components/table/open_flyout_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Button added to the actions column of the indicators table to open/close the IndicatorFlyout component.
 */
const OpenIndicatorFlyoutButton = ({
  indicator,
  onOpen
}) => {
  const open = (0, _react.useCallback)(() => onOpen(indicator), [indicator, onOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.VIEW_DETAILS_BUTTON_LABEL,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _translations.VIEW_DETAILS_BUTTON_LABEL,
    color: "text",
    "data-test-subj": _test_ids.BUTTON_TEST_ID,
    iconType: "expand",
    onClick: open,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }));
};
exports.OpenIndicatorFlyoutButton = OpenIndicatorFlyoutButton;