"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationsGuard = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _test_ids = require("./test_ids");
var _use_integrations = require("../hooks/use_integrations");
var _empty_page = require("../modules/empty_page/empty_page");
var _use_total_count = require("../modules/indicators/hooks/use_total_count");
var _template_wrapper = require("../../app/home/template_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/containers/integrations_guard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Renders the indicators page if the user has some Threat Intelligence integrations installed or
 * the user is receiving indicators.
 * If none are received, show the EmptyPage with a link to go install integrations.
 * While the indicators call and the integrations call are loading, display a loading screen.
 */
const IntegrationsGuard = exports.IntegrationsGuard = /*#__PURE__*/(0, _react.memo)(({
  children
}) => {
  const {
    isLoading: indicatorsTotalCountLoading,
    count: indicatorsTotalCount
  } = (0, _use_total_count.useIndicatorsTotalCount)();
  const {
    isLoading: integrationLoading,
    data: installedTIIntegrations
  } = (0, _use_integrations.useIntegrations)({
    enabled: !indicatorsTotalCountLoading
  });
  if (integrationLoading || indicatorsTotalCountLoading) {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": _test_ids.LOADING_LOGO_WRAPPER_TEST_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_template_wrapper.SecuritySolutionTemplateWrapper, {
      isEmptyState: true,
      emptyPageBody: /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
        color: "transparent",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
        "data-test-subj": _test_ids.LOADING_LOGO_TEST_ID,
        logo: "logoSecurity",
        size: "xl",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 15
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 9
      }
    }));
  }

  // show indicators page if there are indicators, or if some ti integrations have been added
  const showIndicatorsPage = indicatorsTotalCount > 0 || (installedTIIntegrations || []).length > 0;
  return showIndicatorsPage ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children) : /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.EMPTY_PAGE_WRAPPER_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_template_wrapper.SecuritySolutionTemplateWrapper, {
    isEmptyState: true,
    emptyPageBody: /*#__PURE__*/_react.default.createElement(_empty_page.EmptyPage, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 68
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }));
});
IntegrationsGuard.displayName = 'IntegrationsGuard';